% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generateFactorItems}
\alias{generateFactorItems}
\title{Generate paired comparison data for a factor model}
\usage{
generateFactorItems(
  df,
  path,
  factorScalePrior = deprecated(),
  th = 0.5,
  name,
  ...,
  scale = 1,
  alpha = 1
)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}

\item{path}{a named list of item names}

\item{factorScalePrior}{a named numeric vector (deprecated)}

\item{th}{a vector of thresholds}

\item{name}{a vector of item names}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{scale}{a vector of scaling constants}

\item{alpha}{a vector of item discriminations}
}
\value{
The given data.frame \code{df} with additional columns for each item.
In addition, you can obtain path proportions (factor-to-item loadings) from \code{attr(df, "pathProp")},
the factor scores from \code{attr(df, "score")},
and latent worths from \code{attr(df, "worth")}.
}
\description{
Generate paired comparison data given a mapping from factors to items.
}
\details{
For each factor, you need to specify its name and which items it predicts.
The connections from factors to items is specified by the `path` argument.
Both factors and items are specified by name (not index).

Path proportions (factor-to-item loadings) are sampled
  from a logistic transformed normal distribution with scale
  0.6. A few attempts are made to resample path
  proportions if any of the item proportions sum to more than
  1.0. An exception will be raised if repeated attempts fail to
  produce viable proportion assignments.
}
\section{Response model}{


See \link{cmp_probs} for details.
}

\section{Backward incompatibility}{

The function \link{generateFactorItems} was renamed to
  \code{generateSingleFactorItems} (version 1.1.0) to make space for a more
  flexible factor model with an arbitrary number of factors and
  arbitrary factor-to-item loading pattern. If you don't need this
  flexibility, you can call the old function \link{generateSingleFactorItems}.
}

\examples{
df <- twoLevelGraph(letters[1:10], 100)
df <- generateFactorItems(df, list(f1=paste0('i',1:4),
                           f2=paste0('i',2:4)),
                      c(f1=0.9, f2=0.5))
head(df)
attr(df, "pathProp")
attr(df, "score")
attr(df, "worth")
}
\references{
Silver, D., Hubert, T., Schrittwieser, J., Antonoglou, I., Lai, M.,
Guez, A., ... & Lillicrap, T. (2018). A general reinforcement
learning algorithm that masters chess, shogi, and Go through
self-play. \emph{Science, 362}(6419), 1140-1144.
}
\seealso{
To fit a factor model: \link{prepFactorModel}

Other item generators: 
\code{\link{generateCovItems}()},
\code{\link{generateItem}()},
\code{\link{generateSingleFactorItems}()}
}
\concept{item generators}
