% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{IedgeCSstd.tri}
\alias{IedgeCSstd.tri}
\title{The indicator for the presence of an edge from a point to another
for the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs) -
standard equilateral triangle case}
\usage{
IedgeCSstd.tri(
  p1,
  p2,
  t,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines
whether there is an edge from \code{p1} to \code{p2} or not
in the underlying or reflexivity graphs of CS-PCDs.}

\item{t}{A positive real number
which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Returns 1 if there is an edge between points \code{p1} and \code{p2}
in the underlying or reflexivity graph of CS-PCDs
in the standard equilateral triangle, and 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p1p2} is an edge
in the underlying or reflexivity graph of CS-PCDs \eqn{)}
for points \code{p1} and \code{p2} in the standard equilateral triangle.

More specifically, when the argument \code{ugraph="underlying"}, it returns
the edge indicator for points \code{p1} and \code{p2}
in the standard equilateral triangle,
for the CS-PCD underlying graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{CS}(p1,t)} or \code{p1} is in \eqn{N_{CS}(p2,t)},
returns 0 otherwise.
On the other hand,
when \code{ugraph="reflexivity"}, it returns
the edge indicator for points \code{p1} and \code{p2}
in the standard equilateral triangle,
for the CS-PCD reflexivity graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{CS}(p1,t)} and \code{p1} is in \eqn{N_{CS}(p2,t)},
returns 0 otherwise.

In both cases \eqn{N_{CS}(x,t)} is the CS proximity region
for point \eqn{x} with expansion parameter \eqn{t > 0}.
CS proximity region is defined
with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \eqn{T_e}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations (i.e., it allows loops).

See also
(\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
n<-3

set.seed(1)
Xp<-pcds::runif.std.tri(n)$gen.points

M<-as.numeric(pcds::runif.std.tri(1)$g)

IedgeCSstd.tri(Xp[1,],Xp[3,],t=1.5,M)
IedgeCSstd.tri(Xp[1,],Xp[3,],t=1.5,M,ugraph="reflexivity")

P1<-c(.4,.2)
P2<-c(.5,.26)
t<-2
IedgeCSstd.tri(P1,P2,t,M)
IedgeCSstd.tri(P1,P2,t,M,ugraph = "reflexivity")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IedgeCSbasic.tri}}, \code{\link{IedgeCStri}},
and \code{\link[pcds]{IarcCSstd.tri}}
}
\author{
Elvan Ceyhan
}
