% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsMuVarCS2D}
\alias{funsMuVarCS2D}
\alias{muCS2D}
\alias{asyvarCS2D}
\title{Returns the mean and (asymptotic) variance of arc density of  Central Similarity Proximity Catch Digraph (CS-PCD)
for 2D uniform data in one triangle}
\usage{
muCS2D(t)

asyvarCS2D(t)
}
\arguments{
\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}
}
\value{
\code{muCS2D} returns the mean and \code{asyvarCS2D} returns the (asymptotic) variance of the
arc density of CS-PCD for uniform data in any triangle
}
\description{
Two functions: \code{muCS2D} and \code{asyvarCS2D}.

\code{muCS2D} returns the mean of the (arc) density of CS-PCD
and \code{asyvarCS2D} returns the asymptotic variance of the arc density of CS-PCD
with expansion parameter \eqn{t>0} for 2D uniform data in a triangle.

CS proximity regions are defined with respect to the triangle and
vertex regions are based on center of mass, CM of the triangle.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
#Examples for muCS2D
muCS2D(.5)

tseq<-seq(0.01,5,by=.05)
ltseq<-length(tseq)

mu<-vector()
for (i in 1:ltseq)
{
  mu<-c(mu,muCS2D(tseq[i]))
}

plot(tseq, mu,type="l",xlab="t",ylab=expression(mu(t)),lty=1,xlim=range(tseq))

#Examples for asyvarCS2D
asyvarCS2D(.5)

tseq<-seq(0.01,10,by=.05)
ltseq<-length(tseq)

asyvar<-vector()
for (i in 1:ltseq)
{
  asyvar<-c(asyvar,asyvarCS2D(tseq[i]))
}

oldpar <- par(mfrow = c(1,2))
par(mar=c(5,5,4,2))
plot(tseq, asyvar,type="l",xlab="t",ylab=expression(paste(sigma^2,"(t)")),lty=1,xlim=range(tseq))
par(oldpar)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{muPE2D}} and \code{\link{asyvarPE2D}}
}
