% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotPEregsInt}
\alias{plotPEregsInt}
\title{The plot of the Proportional Edge (PE) Proximity Regions for a general interval
(vertices jittered along \eqn{y}-coordinate) - one interval case}
\usage{
plotPEregsInt(
  dat,
  r,
  c = 0.5,
  int,
  Jit = 0.1,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  centers = FALSE,
  ...
)
}
\arguments{
\item{dat}{A set of 1D points for which PE proximity regions are to be constructed.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}; default=\code{0.5}}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{Jit}{A positive real number that determines the amount of jitter along the \eqn{y}-axis, default=\code{0.1} and
\code{dat} points are jittered according to \eqn{U(-Jit,Jit)} distribution along the \eqn{y}-axis where \code{Jit} equals to the range of \code{dat} and proximity region
intervals multiplied by \code{Jit}).}

\item{main}{Title of the main heading of the plot.}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{""} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges.}

\item{centers}{A logical argument, if \code{TRUE}, plot includes the centers of the intervals
as vertical lines in the plot, else centers of the intervals are not plotted.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the PE proximity regions for 1D points in or outside the interval \code{int}
}
\description{
Plots the points in and outside of the interval \code{int} and also the PE proximity regions (which are also intervals).
PE proximity regions are constructed with expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)}.

For better visualization, a uniform jitter from \eqn{U(-Jit,Jit)} (default is \eqn{Jit=.1}) times range of proximity
regions and \code{dat}) is added to the \eqn{y}-direction.
\code{centers} is a logical argument, if \code{TRUE}, plot includes the
centers of the intervals as vertical lines in the plot, else centers of the intervals are not plotted.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

n<-10
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.1

dat<-runif(n,a-xf,b+xf)  #try also dat<-runif(n,a-5,b+5)

plotPEregsInt(7,r,c,int)

plotPEregsInt(dat,r,c,int)

plotPEregsInt(17,r,c,int)
plotPEregsInt(1,r,c,int)
plotPEregsInt(4,r,c,int)

plotPEregsInt(-7,r,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEregsMI}}, \code{\link{plotCSregsInt}}, and \code{\link{plotCSregsMI}}
}
\author{
Elvan Ceyhan
}
