% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rv.end.int}
\alias{rv.end.int}
\title{The index of the vertex region in an end-interval that contains a given point}
\usage{
rv.end.int(pt, int)
}
\arguments{
\item{pt}{A 1D point whose end interval region is provided by the function.}

\item{int}{A \code{vector} of two real numbers representing an interval.}
}
\value{
A \code{list} with two elements
\item{rv}{Index of the end vertex whose region contains point, \code{pt}.}
\item{int}{The vertices of the interval as a \code{vector} where position of the vertex corresponds to
the vertex index as \code{int=(rv=1,rv=2)}.}
}
\description{
Returns the index of the vertex in the interval, \code{int}, whose end interval contains the 1D point \code{pt},
that is, it finds the index of the vertex for the point, \code{pt}, outside
the interval \code{int}\eqn{=(a,b)=}(vertex 1,vertex 2);
vertices of interval are labeled as 1 and 2 according to their order in the interval.

If the point, \code{pt}, is inside \code{int}, then the function yields \code{NA} as output.
The corresponding vertex region is an interval as \eqn{(-\infty,a)} or \eqn{(b,\infty)} for the interval \eqn{(a,b)}.
Then if \eqn{pt<a}, then \code{rv=1} and if \eqn{pt>b}, then \code{rv=2}. Unlike \code{\link{rv.mid.int}}, centrality parameter (i.e., center
of the interval is not relevant for \code{rv.end.int}.)

See also (\insertCite{ceyhan:metrika-2012,ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)

rv.end.int(-6,int)
rv.end.int(16,int)

n<-5
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.5
datL<-runif(n,a-xf,a)
datR<-runif(n,b,b+xf)
dat<-c(datL,datR)
rv.end.int(dat[1],int)

Rv<-vector()
for (i in 1:length(dat))
  Rv<-c(Rv,rv.end.int(dat[i],int)$rv)
Rv

Xlim<-range(a,b,dat)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),xlab="",pch=".",xlim=Xlim+xd*c(-.05,.05))
abline(h=0)
abline(v=c(a,b),col=1,lty=2)
points(cbind(dat,0))
text(cbind(dat,0.1),labels=factor(Rv))
text(cbind(c(a,b),-0.1),c("rv=1","rv=2"))

jit<-.1
yjit<-runif(length(dat),-jit,jit)

Xlim<-range(a,b,dat)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),main="vertex region indices for the points\n in the end intervals",
     xlab=" ", ylab=" ",pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=3*range(yjit))
points(dat, yjit,xlim=Xlim+xd*c(-.05,.05),pch=".",cex=3)
abline(h=0)
abline(v=c(a,b),lty=2)
text(dat,yjit,labels=factor(Rv))
text(cbind(c(a,b),-.01),c("rv=1","rv=2"))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rv.mid.int}}
}
\author{
Elvan Ceyhan
}
