% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{ArcsASMT}
\alias{ArcsASMT}
\title{The arcs of Arc Slice Proximity Catch Digraph (AS-PCD) for a 2D data set - multiple triangle case}
\usage{
ArcsASMT(Xp, Yp, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangulation. The Delaunay
triangles partition the convex hull of \code{Yp} points.}

\item{M}{The center of the triangle. \code{"CC"} represents the circumcenter of each Delaunay triangle \code{tri}
or 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay triangle;
default is \code{M="CC"} i.e., the circumcenter of each triangle.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, it is the center used to construct the vertex regions, i.e.
circumcenter.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the Delaunay triangulation based on \code{Yp} points.}
\item{tess.name}{Name of data set used in tessellation, i.e., \code{Yp}}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of AS-PCD for 2D data set \code{Xp} in the multiple triangle case
as the vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of AS-PCD for 2D data set \code{Xp} in the multiple triangle case
as the vertices of the digraph}
\item{mtitle}{Text for \code{"main"} title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs as tails (or sources) and heads (or arrow ends) of AS-PCD whose vertices are the data set \code{Xp}.

AS proximity regions are defined with respect to the Delaunay triangles based on
\code{Yp} points, i.e., AS proximity regions are defined only for \code{Xp} points inside the convex hull of \code{Yp} points.
That is, arcs may exist for points only inside the convex hull of \code{Yp} points.
It also provides various descriptions and quantities about the arcs of the AS-PCD
such as number of arcs, arc density, etc.

Vertex regions are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle; default is \code{M="CC"} i.e., circumcenter of each triangle.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}) for more on AS PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

ArcsASMT(Xp,Yp,M)

Arcs<-ArcsASMT(Xp,Yp,M)
Arcs
summary(Arcs)
plot(Arcs)

S<-Arcs$S
E<-Arcs$E
DT<-interp::tri.mesh(Yp[,1],Yp[,2],duplicate="remove")

Xlim<-range(Xp[,1],Yp[,1])
Ylim<-range(Xp[,2],Yp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Xp,main=" ", xlab=" ", ylab=" ",xlim=Xlim+xd*c(-.05,.05),
ylim=Ylim+yd*c(-.05,.05),pch=".",cex=3)
interp::plot.triSht(DT, add=TRUE, do.points = TRUE)
arrows(S[,1], S[,2], E[,1], E[,2], length = 0.1, col= 4)

ArcsASMT(Xp,Yp[1:3,],M)

ArcsASMT(Xp,rbind(Yp,Yp),M)

dat.fr<-data.frame(a=Xp)
ArcsASMT(dat.fr,Yp,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ArcsAStri}}, \code{\link{ArcsPEtri}}, \code{\link{ArcsCStri}}, \code{\link{ArcsPEMT}},
and \code{\link{ArcsCSMT}}
}
\author{
Elvan Ceyhan
}
