% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{NumArcsCStri}
\alias{NumArcsCStri}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) - one triangle case}
\usage{
NumArcsCStri(Xp, tri, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of CS-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \code{tri}.}
}
\value{
A \code{list} with the elements
\item{num.arcs}{Number of arcs of the CS-PCD}
\item{num.in.tri}{Number of \code{Xp} points in the triangle, \code{tri}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points that reside in the triangle}
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) whose vertices are the
given 2D numerical data set, \code{Xp}. It also provides number of vertices (i.e., number of data points inside the triangle)
and indices of the data points that reside in the triangle.

CS proximity region \eqn{N_{CS}(x,t)} is defined with respect to the triangle, \code{tri}  with expansion parameter \eqn{t>0}
and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \code{tri} for this function.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

n<-10  #try also n<-20
set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

NumArcsCStri(Xp,Tr,t=.5,M)
NumArcsCStri(Xp,Tr,t=1,M)
NumArcsCStri(Xp,Tr,t=1.5,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCSTe}}, \code{\link{NumArcsCS}}, \code{\link{NumArcsPEtri}},
and \code{\link{NumArcsAStri}}
}
\author{
Elvan Ceyhan
}
