% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{IarcPEtetra}
\alias{IarcPEtetra}
\title{The indicator for the presence of an arc from one 3D point to another 3D point for
Proportional Edge Proximity Catch Digraphs (PE-PCDs)}
\usage{
IarcPEtetra(p1, p2, th, r, M = "CM", rv = NULL)
}
\arguments{
\item{p1}{A 3D point whose PE proximity region is constructed.}

\item{p2}{A 3D point. The function determines whether \code{p2} is inside the PE proximity region of
\code{p1} or not.}

\item{th}{A \eqn{4 \times 3} matrix with each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}

\item{rv}{Index of the \code{M}-vertex region containing the point, either \code{1,2,3,4}
(default is \code{NULL}).}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for \code{p1}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)}, returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for 3D points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise, where N_{PE}(x,r) is the PE proximity region for point \eqn{x} with the expansion parameter \eqn{r \ge 1}.

PE proximity region is constructed with respect to the tetrahedron \code{th} and
vertex regions are based on the center \code{M} which is circumcenter (\code{"CC"}) or
center of mass (\code{"CM"}) of \code{th} with default=\code{"CM"}.
\code{rv} is the index of the vertex region \code{p1} resides, with default=\code{NULL}.

If \code{p1} and \code{p2} are distinct and either of them are outside \code{th}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-3  #try also n<-20

Xp<-runif.tetra(n,tetra)$g

M<-"CM"  #try also M<-"CC"
r<-1.5

IarcPEtetra(Xp[1,],Xp[2,],tetra,r)  #uses the default M="CM"
IarcPEtetra(Xp[1,],Xp[2,],tetra,r,M)

IarcPEtetra(c(.4,.4,.4),c(.5,.5,.5),tetra,r,M)

#or try
RV<-rel.vert.tetraCC(Xp[1,],tetra)$rv
IarcPEtetra(Xp[1,],Xp[3,],tetra,r,M,rv=RV)

P1<-c(.1,.1,.1)
P2<-c(.5,.5,.5)
IarcPEtetra(P1,P2,tetra,r,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcPEstd.tetra}}, \code{\link{IarcPEtri}} and \code{\link{IarcPEint}}
}
\author{
Elvan Ceyhan
}
