% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{Plane}
\alias{Plane}
\title{The plane passing through three distinct 3D points
\code{a}, \code{b}, and \code{c}}
\usage{
Plane(a, b, c, x, y)
}
\arguments{
\item{a, b, c}{3D points that determine the plane
(i.e., through which the plane is passing).}

\item{x, y}{Scalars or vectors of scalars
representing the \eqn{x}- and \eqn{y}-coordinates of the plane.}
}
\value{
A \code{list} with the elements
\item{desc}{A description of the plane}
\item{points}{The input points \code{a}, \code{b},
and \code{c} through which the plane is passing
(stacked row-wise, i.e., row 1 is point \code{a},
row 2 is point \code{b} and row 3 is point \code{c}).}
\item{x,y}{The input vectors which constitutes the \eqn{x}-
and \eqn{y}-coordinates of the point(s) of interest on the
plane. \code{x} and \code{y} can be scalars or vectors of scalars.}
\item{z}{The output \code{vector}
which constitutes the \eqn{z}-coordinates of the point(s) of interest
on the plane.
If \code{x} and \code{y} are scalars, \code{z} will be a scalar and
if \code{x} and \code{y} are vectors of scalars,
then \code{z} needs to be a \code{matrix} of scalars,
containing the \eqn{z}-coordinate
for each pair of \code{x} and \code{y} values.}
\item{coeff}{Coefficients of the plane (in the \eqn{z = A x+B y+C} form).}
\item{equation}{Equation of the plane in long form}
\item{equation2}{Equation of the plane in short form,
to be inserted on the plot}
}
\description{
An object of class \code{"Planes"}.
Returns the equation and \eqn{z}-coordinates of the plane
passing through three distinct 3D points \code{a}, \code{b}, and \code{c}
with \eqn{x}- and \eqn{y}-coordinates are provided
in vectors \code{x} and \code{y}, respectively.
}
\examples{
\dontrun{
P1<-c(1,10,3); P2<-c(1,1,3); P3<-c(3,9,12) #also try P2=c(2,2,3)

pts<-rbind(P1,P2,P3)
Plane(P1,P2,P3,.1,.2)

xr<-range(pts[,1]); yr<-range(pts[,2])
xf<-(xr[2]-xr[1])*.1
#how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1
#how far to go at the lower and upper ends in the y-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=5)  #try also l=10, 20, or 100
y<-seq(yr[1]-yf,yr[2]+yf,l=5)  #try also l=10, 20, or 100

plP123<-Plane(P1,P2,P3,x,y)
plP123
summary(plP123)
plot(plP123,theta = 225, phi = 30, expand = 0.7, facets = FALSE, scale = TRUE)

z.grid<-plP123$z

persp(x,y,z.grid, xlab="x",ylab="y",zlab="z",
theta = -30, phi = 30, expand = 0.5, col = "lightblue",
      ltheta = 120, shade = 0.05, ticktype = "detailed")

zr<-max(z.grid)-min(z.grid)
Pts<-rbind(P1,P2,P3)+rbind(c(0,0,zr*.1),c(0,0,zr*.1),c(0,0,zr*.1))
Mn.pts<-apply(Pts,2,mean)

plot3D::persp3D(z = z.grid, x = x, y = y,theta = 225, phi = 30, expand = 0.3,
main = "Plane Crossing Points P1, P2, and P3", facets = FALSE, scale = TRUE)
#plane spanned by points P1, P2, P3
#add the defining points
plot3D::points3D(Pts[,1],Pts[,2],Pts[,3], add=TRUE)
plot3D::text3D(Pts[,1],Pts[,2],Pts[,3], c("P1","P2","P3"),add=TRUE)
plot3D::text3D(Mn.pts[1],Mn.pts[2],Mn.pts[3],plP123$equation,add=TRUE)
#plot3D::polygon3D(Pts[,1],Pts[,2],Pts[,3], add=TRUE)
}

}
\seealso{
\code{\link{paraplane}}
}
\author{
Elvan Ceyhan
}
