% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtaxonkit.R
\name{taxonkit_name2taxid}
\alias{taxonkit_name2taxid}
\title{Convert Taxonomic Names to TaxIDs}
\usage{
taxonkit_name2taxid(
  file_path,
  name_field = NULL,
  sci_name = FALSE,
  show_rank = FALSE,
  text = FALSE,
  data_dir = NULL
)
}
\arguments{
\item{file_path}{The path to the input file containing taxonomic names. Or file text (text=TRUE)}

\item{name_field}{The field index of the taxonomic name in the input file (default is 1).}

\item{sci_name}{Logical value indicating whether to search only for scientific names (default is FALSE).}

\item{show_rank}{Logical value indicating whether to show the taxonomic rank in the output (default is FALSE).}

\item{text}{Logical}

\item{data_dir}{directory containing nodes.dmp and names.dmp (default "/Users/asa/.taxonkit")}
}
\value{
A character vector containing the output of the "taxonkit_name2taxid" command.
}
\description{
This function uses the "taxonkit taxonkit_name2taxid" command to convert taxonomic names to corresponding taxonomic IDs (TaxIDs).
}
\examples{
\dontrun{
names <- system.file("extdata/name.txt", package = "pctax")
taxonkit_name2taxid(names, name_field = 1, sci_name = FALSE, show_rank = FALSE)
"Homo sapiens" \%>\% taxonkit_name2taxid(text = TRUE)
}
}
