% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthPlot.R
\name{growthPlot}
\alias{growthPlot}
\title{Function to visualize models made by \link{fitGrowth}.}
\usage{
growthPlot(
  fit,
  form,
  groups = NULL,
  df = NULL,
  timeRange = NULL,
  facetGroups = TRUE,
  groupFill = !facetGroups,
  hierarchy_value = NULL
)
}
\arguments{
\item{fit}{A model fit object (or a list of \code{nlrq} models) as returned by \code{fitGrowth}.}

\item{form}{A formula similar to that in \code{growthSS} inputs (or the \code{pcvrForm} part of the
output) specifying the outcome, predictor, and grouping structure of the data as
\code{outcome ~ predictor|individual/group}. Generally this is given directly from
the growthSS output (\code{ss$pcvrForm}). If the formula does not include both individuals
and groups then lines from the data will not be plotted which may be best if your data does not
specify unique individuals and your model does not include autocorrelation.}

\item{groups}{An optional set of groups to keep in the plot.
Defaults to NULL in which case all groups in the model are plotted.}

\item{df}{A dataframe to use in plotting observed growth curves on top of the model and for making
predictions.}

\item{timeRange}{An optional range of times to use. This can be used to view predictions for
future data if the avaiable data has not reached some point (such as asymptotic size).}

\item{facetGroups}{logical, should groups be separated in facets? Defaults to TRUE.}

\item{groupFill}{logical, should groups have different colors? Defaults to the opposite of
facetGroups. If TRUE then
viridis colormaps are used in the order c('plasma', 'mako', 'viridis', 'inferno', 'cividis', 'magma',
'turbo', 'rocket'). Alternatively this can be given as a vector of
viridis colormap names to use in a different order than above.
Note that for brms models this is ignored except if used to specify a different viridis color map
to use.}

\item{hierarchy_value}{If a hierarchical model is being plotted, what value should the
hiearchical predictor be? If left NULL (the default) the mean value is used.}
}
\value{
Returns a ggplot showing a brms model's credible
intervals and optionally the individual growth lines.
}
\description{
Models fit using \link{growthSS} inputs by \link{fitGrowth}
(and similar models made through other means) can be visualized easily using this function.
}
\examples{

simdf <- growthSim("logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 160), "B" = c(13, 11), "C" = c(3, 3.5))
)
ss <- growthSS(
  model = "logistic", form = y ~ time | id / group,
  df = simdf, type = "nls"
)
fit <- fitGrowth(ss)
growthPlot(fit, form = ss$pcvrForm, df = ss$df)

}
\seealso{
\link{growthSS} and \link{fitGrowth} for making compatible models, \link{testGrowth}
for hypothesis testing on compatible models.
}
\keyword{growth-curve}
