% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlrqPlot.R
\name{nlrqPlot}
\alias{nlrqPlot}
\title{Function to visualize common \code{quantreg::nlrq} growth models.}
\usage{
nlrqPlot(
  fit,
  form,
  df = NULL,
  groups = NULL,
  timeRange = NULL,
  facetGroups = TRUE,
  groupFill = FALSE,
  virMaps = c("plasma")
)
}
\arguments{
\item{fit}{A model fit, or list of model fits, returned by \code{fitGrowth} with type="nlrq".}

\item{form}{A formula similar to that in \code{growthSS} inputs (or the \code{pcvrForm} part of the
output) specifying the outcome, predictor, and grouping structure of the data as
\code{outcome ~ predictor|individual/group}. If the individual and group are specified then the
observed growth lines are plotted.}

\item{df}{A dataframe to use in plotting observed growth curves on top of the model.
This must be supplied for nlrq models.}

\item{groups}{An optional set of groups to keep in the plot.
Defaults to NULL in which case all groups in the model are plotted.}

\item{timeRange}{An optional range of times to use. This can be used to view predictions for
future data if the available data has not reached some point (such as asymptotic size).}

\item{facetGroups}{logical, should groups be separated in facets? Defaults to TRUE.}

\item{groupFill}{logical, should groups have different colors? Defaults to FALSE.
If TRUE then viridis colormaps are used in the order of virMaps}

\item{virMaps}{order of viridis maps to use. Will be recycled to necessary length.
Defaults to "plasma", but will generally be informed by growthPlot's default.}
}
\value{
Returns a ggplot showing an nlrq model's quantiles
 and optionally the individual growth lines.
}
\description{
Models fit using \link{growthSS} inputs by \link{fitGrowth}
(and similar models made through other means)
can be visualized easily using this function. This will generally be called by \code{growthPlot}.
}
\examples{

simdf <- growthSim("logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 160), "B" = c(13, 11), "C" = c(3, 3.5))
)
ss <- growthSS(
  model = "logistic", form = y ~ time | id / group,
  tau = c(0.5, 0.9), df = simdf, start = NULL, type = "nlrq"
)
fit <- fitGrowth(ss)
nlrqPlot(fit, form = ss$pcvrForm, df = ss$df, groups = "a", timeRange = 1:20)
nlrqPlot(fit, form = ss$pcvrForm, df = ss$df, groupFill = TRUE, virMaps = c("plasma", "viridis"))

ss <- growthSS(
  model = "logistic", form = y ~ time,
  tau = c(0.5, 0.9), df = simdf, start = NULL, type = "nlrq"
)
fit <- fitGrowth(ss)
nlrqPlot(fit, form = ss$pcvrForm, df = ss$df)

}
\keyword{growth-curve}
