% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pds3_read.R
\name{pds3_read}
\alias{pds3_read}
\title{Parse PDS3}
\usage{
pds3_read(x, util = pds3_lexer_parser(), assume_complete = TRUE)
}
\arguments{
\item{x}{A String of the PDS3 to parse, containing one of the following:
\describe{
  \item{Content}{String you want to parse}
  \item{Filename}{Path to a file containing a PDS3}
}}

\item{util}{A list containing a PDS3 lexer & parser as returned by
`getLexerParser()`. Typically not required, but improves performance if
parsing many files.}

\item{assume_complete}{(default: TRUE) Assume that there is no content after
'END'. If set to false, will pre-parse the file to find END. If you start
getting parsing errors, you may need to set this flag to false.}
}
\value{
A list with the following components:
  \describe{
    \item{label}{Raw label content. If there is extra_data, it will be excluded}
    \item{extra_data}{Content following 'END'. If assume_complete is F or
      there is no content after the label, this will be  an empty string}
    \item{odl}{Parsed label content.}
  }
}
\description{
Parses a PDS3 file to extract meta information
}
\examples{
pds3_read('PDS_VERSION_ID = PDS3
 PRODUCT_CREATION_TIME         = 2017-05-31T18:42:49
 END')
}
