% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prsp_score.R
\name{form_request}
\alias{form_request}
\title{Create a GET request for Perspective API}
\usage{
form_request(score_model, text, score_sentences, languages,
  doNotStore = F)
}
\arguments{
\item{score_model}{Specify what model do you want to use (for example \code{TOXICITY} and/or \code{SEVERE_TOXICITY}). Specify a character vector if you want more than one score. See \code{peRspective::prsp_models}.}

\item{text}{a character string.}

\item{score_sentences}{A boolean value that indicates if the request should return spans that describe the scores for each part of the text (currently done at per sentence level). Defaults to \code{FALSE}.}

\item{languages}{A vector of \href{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}{ISO 631-1} two-letter language codes specifying the language(s) that comment is in (for example, "en", "es", "fr", "de", etc). If unspecified, the API will autodetect the comment language. If language detection fails, the API returns an error.}

\item{doNotStore}{Whether the API is permitted to store comment from this request. Stored comments will be used for future research and community model building purposes to improve the API over time. Perspective API also plans to provide dashboards and automated analysis of the comments submitted, which will apply only to those stored. Defaults to \code{FALSE} (request data may be stored). Important note: This should be set to true if data being submitted is private (i.e. not publicly accessible), or if the data submitted contains content written by someone under 13 years old.}
}
\value{
a \code{tibble}
}
\description{
For more details see \code{?peRspective} or \href{https://github.com/conversationai/perspectiveapi/blob/master/api_reference.md}{Perspective API documentation}
}
