% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont2cat.R
\name{cont2cat}
\alias{cont2cat}
\alias{breakPoints}
\alias{stratify}
\title{Categorize/stratify continuous variable(s)}
\usage{
cont2cat(x, breaks, integer = FALSE)

breakPoints(x, n, type = "area", prop = FALSE)

stratify(x, n, type = "area", integer = FALSE)
}
\arguments{
\item{x}{Vector, data frame or matrix with data on the continuous variable(s) to be categorized/stratified.}

\item{breaks}{Vector or list containing the lower and upper limits that should be used to break the
continuous variable(s) into categories. See \sQuote{Details} for more information.}

\item{integer}{Logical value indicating if the categorical variable(s) be returned as \code{integer}s. Defaults
to \code{integer = FALSE}, i.e. the variable(s) will be returned as \code{factor}s.}

\item{n}{Integer value indicating the number of strata that should be created.}

\item{type}{Character value indicating the type of strata that should be used, with options \code{"area"}, for
equal-area, and \code{"range"}, for equal-range strata. Defaults to \code{type = "area"}.}

\item{prop}{Logical value indicating if the strata proportions should be returned? Defaults to
\code{prop = FALSE}.}
}
\value{
A vector, data frame, or matrix, depending on the class of \code{x}.
}
\description{
Create break points, compute strata proportions, and stratify continuous variable(s) to create categorical
variable(s).
}
\details{
Argument \code{breaks} must be a vector if \code{x} is a vector, but a list if \code{x} is a data frame or matrix. Using a
list allows breaking each column of \code{x} into different number of categories.
}
\examples{

## Compute the break points of marginal strata
x <- data.frame(x = round(rnorm(10), 1), y = round(rlnorm(10), 1))
x <- breakPoints(x = x, n = 4, type = "area", prop = TRUE)
x

## Convert continuous data into categorical data
# Matrix
x <- y <- c(1:10)
x <- cbind(x, y)
breaks <- list(c(1, 2, 4, 8, 10), c(1, 5, 10))
y <- cont2cat(x, breaks)
y
# Data frame
x <- y <- c(1:10)
x <- data.frame(x, y)
breaks <- list(c(1, 2, 4, 8, 10), c(1, 5, 10))
y <- cont2cat(x, breaks, integer = TRUE)
y
# Vector
x <- c(1:10)
breaks <- c(1, 2, 4, 8, 10)
y <- cont2cat(x, breaks, integer = TRUE)
y

## Stratification
x <- data.frame(x = round(rlnorm(10), 1), y = round(rnorm(10), 1))
x <- stratify(x = x, n = 4, type = "area", integer = TRUE)
x
}
\seealso{
\code{\link[Hmisc]{cut2}}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
