% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merlin.R
\name{merlin}
\alias{merlin}
\alias{likelihoodMerlin}
\title{Pedigree likelihood computed by MERLIN}
\usage{
merlin(
  x,
  options,
  markers = NULL,
  verbose = TRUE,
  generateFiles = TRUE,
  cleanup = TRUE,
  dir = tempdir(),
  logfile = NULL
)

likelihoodMerlin(x, ...)
}
\arguments{
\item{x}{a \code{\link{ped}} object.}

\item{options}{a single string containing all arguments to merlin except for
the input file indications.}

\item{markers}{a vector of names or indices of markers attached to \code{x}.
(Default: all markers).}

\item{verbose}{a logical.}

\item{generateFiles}{a logical. If TRUE (default), input files to MERLIN
named '_merlin.ped', '_merlin.dat', '_merlin.map', and '_merlin.freq' are
created in the directory indicated by \code{dir}. If FALSE, no files are
created.}

\item{cleanup}{a logical. If TRUE (default), the MERLIN input files are
deleted after the call to MERLIN.}

\item{dir}{the name of the directory where input files should be written.}

\item{logfile}{a character. If this is given, the MERLIN screen output will
be dumped to a file with this name.}

\item{...}{Further arguments passed on to \code{merlin}}
}
\value{
\code{merlin()} returns the screen output of MERLIN invisibly.

\code{likelihoodMerlin()} returns a single number; the total likelihood using
all indicated markers.
}
\description{
For this functions to work, the program MERLIN (see References below) must be
installed and correctly pointed to in the PATH variable. The \code{merlin()}
function is a general wrapper which runs MERLIN with the indicated options,
after creating the appropriate input files. For convenience, MERLIN's
"--likelihood" functionality is wrapped in a separate function.
}
\details{
The \code{merlin()} function creates input files "_merlin.ped", "_merlin.dat",
"_merlin.map" and "_merlin.freq" in the \code{dir} directory, and then runs the
following command through a call to \code{\link[=system]{system()}}:

\preformatted{merlin -p _merlin.ped -d _merlin.dat -m _merlin.map -f
_merlin.freq  <options> }

\code{likelihoodMerlin()} first runs \code{merlin()} with \code{options = "--likelihood --bits:100 --megabytes:4000 --quiet"}, and then extracts the likelihood
values from the MERLIN output. Note that the output is the \emph{total} likelihood
including all markers.
}
\examples{

\donttest{
### Requires MERLIN to be installed ###

x = nuclearPed(1)
m1 = marker(x, "1" = 1:2)           # likelihood = 1/2
m2 = marker(x, "1" = 1, "3" = 1:2)    # likelihood = 1/8
x = setMarkers(x, list(m1,m2))

# Likelihood computation by MERLIN:
lik1 = likelihoodMerlin(x, markers = 1, verbose = FALSE)
lik2 = likelihoodMerlin(x, markers = 2, verbose = FALSE)
likTot = likelihoodMerlin(x, verbose = FALSE)
stopifnot(all.equal(
  round(c(lik1, lik2, likTot), c(3,3,4)), c(1/2, 1/8, 1/16)))

y = list(singleton(1), singleton(2))
y = setMarkers(y, locus = list(alleles=1:2))
genotype(y[[1]], marker = 1, id = '1') = 1:2
genotype(y[[2]], marker = 1, id = '2') = 1
lik = likelihoodMerlin(y, verbose = FALSE)
stopifnot(all.equal(round(lik, 3), 1/8))
}

}
\references{
\url{http://csg.sph.umich.edu/abecasis/Merlin/}
}
\author{
Magnus Dehli Vigeland
}
