#' pedtools: Tools for working with pedigrees in R
#'
#' A comprehensive collection of tools for creating, manipulating and
#' visualising pedigrees and genetic marker data. Pedigrees can be read from
#' text files or created on the fly with built-in functions. A range of
#' utilities enable modifications like adding or removing individuals, breaking
#' loops, and merging pedigrees. Pedigree plots are produced by wrapping the
#' plotting functionality of the `kinship2` package. A Shiny app for creating
#' pedigrees, based on `pedtools`, is available at
#' <https://magnusdv.shinyapps.io/quickped>. `pedtools` is the hub of the `ped
#' suite`, a collection of packages for pedigree analysis. A detailed
#' presentation of the `ped suite` is given in the book [Pedigree Analysis in
#' R](https://www.elsevier.com/books/pedigree-analysis-in-r/vigeland/978-0-12-824430-2)
#' (Vigeland, 2021, ISBN:9780128244302).
#'
#' @docType package
#'
#' @name pedtools
NULL
