% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.lambda.R
\name{default.lambda}
\alias{default.lambda}
\title{Default values for L1 penalty in conditional logistic regression}
\usage{
default.lambda(X, Y, stratum, nfolds = 10, alpha = 1)
}
\arguments{
\item{X}{A matrix of covariates, with the number of rows equalling the number
of observations.}

\item{Y}{A binary response variable.}

\item{stratum}{A numeric vector with stratum membership of each observation.}

\item{nfolds}{The number of folds used in cross-validation. Default is 10.}

\item{alpha}{The elastic net mixing parameter, a number between 0 and 1.
alpha=0 would give pure ridge; alpha=1 gives lasso. Pure ridge penalty is never obtained in this implementation since alpha must be positive.}
}
\value{
A numeric vector of length 1 to 3 (depending on the problem)
giving L1 penalties
}
\description{
Performs cross validation to determine reasonable default values for L1 penalty
in a conditional logistic regression
}
