% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{collinearity_check}
\alias{collinearity_check}
\title{Checking for Perfect Multicollinearity}
\usage{
collinearity_check(y, x, fes, hdfetol)
}
\arguments{
\item{y}{Dependent variable (a numeric vector).}

\item{x}{Regressor matrix.}

\item{fes}{List of fixed effects.}

\item{hdfetol}{Tolerance for the centering, passed on to \code{lfe::demeanlist}.}
}
\value{
A numeric vector containing the variables that pass the collinearity check.
}
\description{
\code{collinearity_check} checks for perfect multicollinearity in a model with high-dimensional
fixed effects. It calls \code{lfe::demeanlist} in order to partial out the fixed effects, and then
uses \code{stats::lm.wfit} to discard linearly dependent variables.
}
