% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_SNV_utility_functions.R
\name{getNextRightFocal}
\alias{getNextRightFocal}
\title{Expand the neighborhood to the right}
\usage{
getNextRightFocal(current, absDist)
}
\arguments{
\item{current}{Current SNVs in the neighborhood of focal SNV.}

\item{absDist}{Absolute distance of SNVs from the focal SNV in base pairs.}
}
\value{
An index of a SNV.
}
\description{
This function tries to expand the neighborhood to the right, when the next SNV
from \code{\link{getNextFromFocal}} function is incompatible with each SNV in
the neighborhood of the focal SNV, and this incompatible SNV could be to the
left of the neighborhood.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

focalSNV = 10
# Proximity to the focal SNV.
absDistFromFocal = abs(ex_hapMatSmall_data$posns - ex_hapMatSmall_data$posns[focalSNV]) 

# Expand the neighborhood to the right.
nxtRight = getNextRightFocal(current = c(focalSNV,focalSNV) , absDist = absDistFromFocal)

}

}
\keyword{internal}
