% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_SNV_utility_functions.R
\name{orderColsAncestry}
\alias{orderColsAncestry}
\title{Utility function needed by \code{\link{orderSNVs}}}
\usage{
orderColsAncestry(M)
}
\arguments{
\item{M}{hapMat object with compatible SNVs.}
}
\value{
A hapMat object with SNVs ordered according to their ancestry.
}
\description{
This function orders the compatible SNVs in the window around the focal point by their ancestry.
}
\details{
This function sorts columns of M as binary numbers in descending order.
The first row of M is the first digit of the binary numbers, the second row of M is the second digit, etc.
This guarantees that more ancestral SNVs appear before more recent SNVs.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# Order SNV by their ancestry.

ex_hapMatSmall_data$hapmat[, orderColsAncestry(ex_hapMatSmall_data$hapmat)]
}

}
\seealso{
\code{\link{orderSNVs}}
}
\keyword{internal}
