% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{maketangle}
\alias{maketangle}
\title{Create a gray scale tanglegram}
\usage{
maketangle(dend1, dend2, cutheight, k = NULL, ncol = k, ...)
}
\arguments{
\item{dend1}{First dendrogram. Required.}

\item{dend2}{Second dendrogram. Required.}

\item{cutheight}{The height, at which dend1 is cut. Influences number of colors.}

\item{k}{Number of desired linkage groups.}

\item{ncol}{Number of desired colors.}

\item{...}{Other parameters are forwarded to the tanglegram command.}
}
\value{
None. Plotting only.
}
\description{
Create tanglegram. Removes markers, that are not in both trees.
Calculates alternating light and dark shades of grey.
}
\examples{
data(simTetra)
simTetraGen <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetraGen, 4)
split <- splitChr(rfMat, nchr = 7)
split <- sortLeafs(rfMat, split)
map <- pullMap(rfMat, split = split)  
dend <- map2dend(map)  
maketangle(dend, dend, cutheight = 500, k = 7, ncol = 7)
}

