% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmPerm.R
\name{permu.test}
\alias{permu.test}
\title{Permutation tests for time series data, based on classic linear regression or ANOVA
This is a legacy function that is primarily provided for backward compatibility. You should probably use \code{perm.lm} or \code{perm.lmer} instead.
\code{permu.test} is the only function to support multivariate responses, although multivariate data can trivially be recoded into a univariate model.
\code{permu.test} does not support random effects or corrected p-values (e.g. the cluster mass test), which are supported by \code{permutelm}.}
\usage{
permu.test(
  formula,
  data,
  subset = NULL,
  type = "anova",
  parallel = FALSE,
  progress = "text",
  ...
)
}
\arguments{
\item{formula}{A formula of the following form: \code{outcome ~ predictors | series variable}. Multivariate outcomes (e.g. 32 EEG electrodes) are supported; use \code{cbind(Fp1,Fp2,etc) ~ predictors | series}.}

\item{data}{The dataset referencing these predictors.}

\item{subset}{If specified, will only analyze the specified subset of the data.}

\item{type}{A character string of either \code{'anova'} or \code{'regression'}. The former runs an analysis of variance and returns F-values and p-values based on the explained variance of each factor in the design. The latter runs a linear-regression analysis and returns t-values and p-values based on individual effects. When running ANOVA, it is advised to use orthogonal predictors, as type III sums of squares are used.}

\item{parallel}{Whether to parallelize the permutation testing using plyr's \code{parallel} option. Needs some additional set-up; see the plyr documentation.}

\item{progress}{A plyr \code{.progress} bar name, see the plyr documentation. Ignored if parallel=TRUE.}

\item{...}{Other arguments to be passed to \code{lmp}/\code{aovp}}
}
\value{
A data frame.
}
\description{
Permutation tests for time series data, based on classic linear regression or ANOVA
This is a legacy function that is primarily provided for backward compatibility. You should probably use \code{perm.lm} or \code{perm.lmer} instead.
\code{permu.test} is the only function to support multivariate responses, although multivariate data can trivially be recoded into a univariate model.
\code{permu.test} does not support random effects or corrected p-values (e.g. the cluster mass test), which are supported by \code{permutelm}.
}
\examples{
\donttest{
# EEG data example using the MMN dataset

# Run permutation tests on all electrodes and timepoints, reporting p-values for the three
# manipulated factors
perms <- permu.test(cbind(Fp1,AF3,F7,F3,FC1,FC5,C3,CP1,CP5,P7,P3,Pz,PO3,O1,Oz,O2,PO4,P4,
	P8,CP6,CP2,C4,FC6,FC2,F4,F8,AF4,Fp2,Fz,Cz) ~ Deviant * Session | Time,data=MMN)

# Run the tests in parallel on two CPU threads
# first, set up the parallel backend
library(doParallel)
cl <- makeCluster(2)
registerDoParallel(cl)
perms <- permu.test(cbind(Fp1,AF3,F7,F3,FC1,FC5,C3,CP1,CP5,P7,P3,Pz,PO3,O1,Oz,O2,PO4,P4,
	P8,CP6,CP2,C4,FC6,FC2,F4,F8,AF4,Fp2,Fz,Cz) ~ Deviant * Session | Time,data=MMN,
	parallel=TRUE)
stopCluster(cl)

# Plot the results by F-value, removing points that were not significant in the
# permutation tests
plot(perms,sig='p')

# t-values instead of F-values
perms <- permu.test(cbind(Fp1,AF3,F7,F3,FC1,FC5,C3,CP1,CP5,P7,P3,Pz,PO3,O1,Oz,O2,PO4,P4,
	P8,CP6,CP2,C4,FC6,FC2,F4,F8,AF4,Fp2,Fz,Cz) ~ Deviant * Session | Time,data=MMN,
	type='regression')
}
\dontshow{
perms <- permu.test(Fp1 ~ Deviant*Session | Time,data=MMN[MMN$Time > 200 & MMN$Time < 205,])
perms <- permu.test(cbind(Fp1,Fp2) ~ Deviant*Session | Time,data=MMN[MMN$Time > 200 & MMN$Time < 205,])
perms <- permu.test(Fp1 ~ Deviant*Session | Time,data=MMN[MMN$Time > 200 & MMN$Time < 205,],type='regression')
perms <- permu.test(cbind(Fp1,Fp2) ~ Deviant*Session | Time,data=MMN[MMN$Time > 200 & MMN$Time < 205,],type='regression')
}
}
\seealso{
\code{clusterperm.lm}, \code{clusterperm.lmer}
}
