% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverseScore.R
\name{reverse_score}
\alias{reverse_score}
\title{Reverse Score Variables.}
\usage{
reverse_score(
  data,
  variables,
  theoretical_max = NULL,
  theoretical_min = NULL,
  append_string = NULL
)
}
\arguments{
\item{data}{Data object.}

\item{variables}{Names of variables to reverse score.}

\item{theoretical_max}{(Optional): the theoretical maximum score.}

\item{theoretical_min}{(Optional): the theoretical minimum score.}

\item{append_string}{(Optional): a string to append to each variable name.}
}
\value{
Dataframe with reverse-scored variables.
}
\description{
Reverse score variables using either the theoretical min and max, or the
observed max.
}
\details{
Reverse scores variables using either the theoretical min and max (by
subtracting the theoretical maximum from each score and adding the
theoretical minimum to each score) or by subtracting each score from the
maximum score for that variable.
}
\examples{
mydata <- data.frame(
  var1 = c(1, 2, NA, 4, 5),
  var2 = c(NA, 4, 3, 2, 1)
)

variables_to_reverse_score <- c("var1", "var2")

reverse_score(
  mydata,
  variables = variables_to_reverse_score)

reverse_score(
  mydata,
  variables = variables_to_reverse_score,
  append_string = ".R")

reverse_score(
  mydata,
  variables = variables_to_reverse_score,
  theoretical_max = 7)

reverse_score(
  mydata,
  variables = variables_to_reverse_score,
  theoretical_max = 7,
  theoretical_min = 1)
}
