% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cc.manip}
\alias{[.comparative.comm}
\alias{assemblage.phylogenies}
\alias{cc.manip}
\alias{env.names}
\alias{sites}
\alias{sites<-}
\alias{species}
\alias{species<-}
\alias{trait.names}
\alias{within.comparative.comm}
\title{Manipulating and examining comparative.comm objects}
\usage{
\method{[}{comparative.comm}(x, sites, spp, warn = FALSE)

trait.names(object)

env.names(object)

species(x)

species(x) <- value

sites(x)

sites(x) <- value

assemblage.phylogenies(data)

\method{within}{comparative.comm}(data, expr, ...)
}
\arguments{
\item{x}{\code{comparative.comm} object}

\item{sites}{numbers of sites to be kept or dropped from \code{x};
must be given as numbers. For example, \code{x[1:5,]}, or
\code{x[-1:-5,]}, but not \code{x[c("site a", "site b"),]}.}

\item{spp}{numbers of species to be kept or dropped from \code{x};
must be given as numbers. For example, \code{x[,1:5]}, or
\code{x[,-1:-5]}, but not \code{x[c("sp a", "sp b"),]}.}

\item{warn}{whether to warn if species/sites are dropped when
creating object (default: TRUE)}

\item{object}{A \code{\link{comparative.comm}} object}

\item{value}{values to replace \code{object}}

\item{data}{A \code{\link{comparative.comm}} object}

\item{expr}{expression to be evaluated within the scope of
\code{data}}

\item{...}{ignored}
}
\value{
Names of the traits or environmental variables

List of \code{\link[ape:phylo]{phylo}} objects, one for
each assemblage in the \code{data}.
}
\description{
As described in the vignette, we recommend using these wrappers to
manipulate species and site data, as it guarantees that everything
will be kept consistent across all parts of the
\code{\link{comparative.comm}} object. However, remember that you
can manipulate the internal components of a
\code{\link{comparative.comm}} object directly, and this is useful
if you want to play around with traits, add in new data, etc.

Manipulate internals of \code{comparative.comm} object
}
\note{
As described in \code{\link{comparative.comm}}, each
\code{\link{comparative.comm}} object contains a phylogeny
(\code{$phy}) and a site-by-species community matrix (as used in
\code{\link{vegan}}). Optionally, it may contain a
\code{data.frame} of trait data (each row a species, each column a
trait ) *called \code{data}* for compatibility with
\code{\link[caper:comparative.data]{comparative.data}}.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits, river.env)
#Subset on species, then sites
data <- data[1:5,]
data <- data[,1:5]
#Site and species can be manipulated
species(data)
sites(data)[1:3] <- c("lovely", "invert", "sites")
#Other data can be viewed
trait.names(data)
env.names(data)
#Get assemblage phylogenies of all sites
assemblage.phylogenies(data)
#Do some manual manipulation of your objects (NOTE: $data for traits)
data$data$new.trait <- sample(letters, nrow(data$comm), replace=TRUE)
}
\seealso{
comparative.comm plot.comaparative.comm
}

