% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fingerprint.regression.R
\name{fingerprint.regression}
\alias{fingerprint.regression}
\alias{plot.fingerprint.regression}
\alias{print.fingerprint.regression}
\alias{summary.fingerprint.regression}
\title{Regress trait evolution against trait ecology (following
Cavender-Bares et al. 2004)}
\usage{
fingerprint.regression(data, eco.rnd = c("taxa.labels", "richness",
  "frequency", "sample.pool", "phylogeny.pool", "independentswap", "trialswap"),
  eco.method = c("quantile", "lm", "mantel"), eco.permute = 1000,
  evo.method = c("lambda", "delta", "kappa", "blom.k"), eco.swap = 1000,
  abundance = TRUE, ...)

\method{print}{fingerprint.regression}(x, ...)

\method{summary}{fingerprint.regression}(object, ...)

\method{plot}{fingerprint.regression}(x, eco = c("slope", "corrected"),
  xlab = "Community Trait Similarity", ylab = "Phylogenetic inertia", ...)
}
\arguments{
\item{data}{\code{\link{comparative.comm}} for analysis}

\item{eco.rnd}{null distribution with which to compare your
community data, one of: \code{taxa.labels} (DEFAULT),
\code{richness}, \code{frequency}, \code{sample.pool},
\code{phylogeny.pool}, \code{independentswap}, \code{trialswap} (as
implemented in \code{\link{picante}})}

\item{eco.method}{how to compare distance matrices (only the lower
triangle;), one of: \code{\link{lm}} (linear regression),
\code{quantile} (DEFAULT; \code{\link[quantreg:rq]{rq}}),
\code{mantel} (\code{\link[vegan:mantel]{mantel}})}

\item{eco.permute}{number of permutations for ecological null model
(\code{eco.rnd}); default 1000}

\item{evo.method}{how to measure phylogenetic inertia, one of:
\code{lambda} (default), \code{delta}, \code{kappa}, \code{blom.k};
see \code{\link{phy.signal}}.}

\item{eco.swap}{number of independent swap iterations to perform
(if specified in \code{eco.rnd}; DEFAULT 1000)}

\item{abundance}{whether to incorporate species' abundances
(default: TRUE)}

\item{...}{additional parameters to pass on to model fitting
functions and plotting functions}

\item{x}{\code{fingerprint.regression} object}

\item{object}{\code{fingerprint.regression} object}

\item{eco}{plot the observed slopes (DEFAULT: \code{slope}), or the
median difference between the simulations and the observed values
(\code{corrected})}

\item{xlab}{label for x-axis (default "Ecological Trait Coexistence")}

\item{ylab}{label for y-axis (default "Phylogenetic inertia")}
}
\description{
Calculates traits' phylogenetic inertia and regresses this against
trait similarity among co-existing species (sensu Cavender-Bares et
al. 2004 Figure 6)
}
\details{
While the term `fingerprint regression' is new to pez, the method
is very similar to that employed in Cavender-Bares et al. 2004
Figure 6. For each trait, the phylogenetic inertia of species%
traits is regressed against their co-occurrence in the community
matrix. Note that Pagel's \eqn{$\lambda$}{lambda},
\eqn{$\delta$}{delta}, and \eqn{$\kappa$}{kappa}, and Blomberg's K,
can be used, unlike the original where a mantel test was
employed. Moreover, note also that Pianka's distance (as described
in the manuscript) is used to measure species overlap.
}
\note{
Like \code{\link{eco.xxx.regression}}, this is a data-hungry
method. Warnings will be generated if any of the methods cannot be
fitted properly (the examples below give toy examples of this). In
such cases the summary and plot methods of these functions may
generate errors; perhaps using \code{\link{traceback}} to examine
where these are coming from, and consider whether you want to be
working with the data generating these errors. I am loathe to hide
these errors or gloss over them, because they represent the reality
of your data!

WDP loves quantile regressions, and advises that you check
different quantiles using the \code{tau} options.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits, river.env)
fingerprint.regression(data, eco.permute=10)
plot(fingerprint.regression(data, permute=10, method="lm"))
}
\author{
Will Pearse and Jeannine Cavender-Bares
}
\references{
Cavender-Bares J., Ackerly D.D., Baum D.A. & Bazzaz F.A. (2004) Phylogenetic overdispersion in Floridian oak communities. The Americant Naturalist 163(6): 823--843.

Kembel, S.W., Cowan, P.D., Helmus, M.R., Cornwell, W.K., Morlon, H., Ackerly, D.D., Blomberg, S.P. & Webb, C.O. Picante: R tools for integrating phylogenies and ecology. Bioinformatics 26(11): 1463--1464.

Pagel M. Inferring the historical patterns of biological evolution. Nature 401(6756): 877--884.
}
\seealso{
\code{\link{eco.xxx.regression}} \code{\link{phy.signal}}
}

