#This may need checking on other systems, because I'm using exact value checks with no consideration of precision...
#Setup
if(FALSE){
require(testthat)
require(pez)
require(picante)
data(phylocom)
data <- comparative.comm(phylocom$phylo, phylocom$sample, warn=FALSE)
context("Generic metrics")
test_that("PSV", expect_equal(.psv(data), c(0.485714285714286, 0.6, 0.714285714285714, 0.828571428571429, 0.885714285714286, 0.842857142857143)))
test_that("PSR", expect_equal(.psr(data), c(3.88571428571429, 4.8, 5.71428571428571, 6.62857142857143, 7.08571428571429, 6.74285714285714)))
test_that("MPD", expect_equal(.mpd(data), c(4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143)))
test_that("MIPD", expect_equal(.mipd(data), c(0.238095238095238, 0.214285714285714, 0.2, 0.164285714285714, 0.116666666666667, 0.12797619047619)))
test_that("MNTD", expect_equal(.mntd(data), c(2,2,2,2,6,5)))
test_that("INND", expect_equal(.innd(data), c(0.166666666666667, 0.125, 0.1, 0.1, 0.1, 0.1)))
test_that("Taxon", expect_equivalent(.taxon(data, abundance.weighted=TRUE), as.data.frame(matrix(c(4.85714285714286, 5.39393939393939, 6.36363636363636, 7.57575757575758, 8.85714285714286, 7.58333333333333, 4.85714285714286, 5.74193548387097, 6.7741935483871, 8.06451612903226, 8.85714285714286, 8.42592592592593, 2.12244897959184, 5.71428571428572, 11.265306122449, 7.3469387755102, 2.12244897959182, 3.81632653061224, 4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143, 38.8571428571429, 48, 57.1428571428571, 66.2857142857143, 70.8571428571429, 67.4285714285714), ncol=5))))
test_that("Taxon", expect_equivalent(.taxon(data, abundance.weighted=TRUE), as.data.frame(matrix(c(4.85714285714286, 5.39393939393939, 6.36363636363636, 7.57575757575758, 8.85714285714286, 7.58333333333333, 4.85714285714286, 5.74193548387097, 6.7741935483871, 8.06451612903226, 8.85714285714286, 8.42592592592593, 2.12244897959184, 5.71428571428572, 11.265306122449, 7.3469387755102, 2.12244897959182, 3.81632653061224, 4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143, 38.8571428571429, 48, 57.1428571428571, 66.2857142857143, 70.8571428571429, 67.4285714285714), ncol=5))))
test_that("Taxon", expect_equivalent(.taxon(data), as.data.frame(matrix(c(4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143, 4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143, 2.12244897959184, 5.71428571428572, 11.265306122449, 7.3469387755102, 2.12244897959182, 3.81632653061224, 4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143, 38.8571428571429, 48, 57.1428571428571, 66.2857142857143, 70.8571428571429, 67.4285714285714), ncol=5))))
test_that("PD", expect_equivalent(.pd(data, abundance.weighted=TRUE), cbind(c(16, 17, 18, 22, 30, 27), c(-4.88235294117647, -4.82352941176471, -3.82352941176471, 0.176470588235294, 9.11764705882352, 4.23529411764706))))
test_that("PD", expect_equivalent(.pd(data, abundance.weighted=FALSE), cbind(c(16, 17, 18, 22, 30, 27), c(-5.66666666666666, -4.66666666666667, -3.66666666666667, 0.333333333333332, 8.33333333333333, 5.33333333333333))))
test_that("Colless", expect_equivalent(.colless(data), c(0, 0, 0, 0, 0, 5)))
test_that("Gamma", expect_equivalent(.gamma(data), c(-1.41421356237309, -0.707106781186547, -0.157134840263678, -0.385694607919935, -2.9227080289044, -2.19988776369148)))
test_that("Eigenvectors", {
    expect_equivalent(.eigen.sum(data), c(1.85989806057967e-32, 9.80257655161354e-05, 0.0580509448862977, 0.0456171567606935, 0.0434666292330911, 0.0476659578856296))
  expect_equivalent(.eigen.sum(data, which.eigen=2), c(3.30159419037812e-32, 0.082086748214039, 0.0137252988148037, 0.0415764004365078, 0.0384905400587625, 0.0452932152543931))
})
test_that("EED", expect_equal(.eed(data), c(3.202317, 3.104838, 3.013283, 2.697896, 2.241960, 2.391608), tolerance=0.00001))
test_that("HED", expect_equal(.hed(data), setNames(c(6.659032, 6.456330, 6.265945, 5.610116, 4.662026, 4.973210),rownames(data$comm)), tolerance=0.00001))
test_that("Rao", expect_equivalent(.rao(data), c(2.125, 2.47222222222222, 2.91666666666667, 3.47222222222222, 3.875, 3.5546875)))
test_that("Entropy", expect_equivalent(.phylo.entropy(data), c(2.07944154167984, 4.62549821485909, 5.2620123831539, 6.64830674427379, 8.31776616671934, 7.22716285080812)))
test_that("PAE", expect_equivalent(.pae(data), c(1.34408602150538, 0, 0.342465753424658, 0.722543352601156, 1.07003891050584, 1.08695652173913)))
test_that("IAC", expect_equivalent(.iac(data), c(0.5, 0.75, 0.75, 0.6875, 0.416666666666667, 0.916666666666667)))
test_that("Haed", expect_equivalent(.haed(data), c(c(2.07944154167984, 2.43261844647745, 2.42601513195981, 2.42601513195981, 2.07944154167984, 2.67765404685526))))
test_that("Eaed", expect_equivalent(.eaed(data), c(1, 0.978957679027899, 0.976300309778954, 0.976300309778954, 1, 0.965759553653586)))
set.seed(123); test_that("Delta", expect_equal(.delta(data), c(NA, 1e-06, 1e-06, 1e-06, NA, 3)))
set.seed(123); test_that("Kappa", expect_equal(.kappa(data), c(NA, 3, 3, 3, NA, 1.65281212634147)))
set.seed(123); test_that("Lambda", expect_equivalent(.lambda(data), c(NA, 1, 1, 1, NA, 1e-06)))
test_that("Scheiner q=0", expect_equivalent(.scheiner(data,0), c(8,8,8,8,8,8)))
test_that("Scheiner q=1", expect_equivalent(.scheiner(data,1), c(8, 8, 8, 8, 8, 7.97184190215649)))
test_that("Scheiner q=2 abundance", expect_equivalent(.scheiner(data,2,TRUE), c(8, 7.2, 7.2, 7.2, 8, 6.5225256442268)))

#Dispersion
test_that("SESmpd", expect_equal(.ses.mpd(data)[,2], c(4.85714285714286, 6, 7.14285714285714, 8.28571428571429, 8.85714285714286, 8.42857142857143)))
test_that("SESmntd", expect_equal(.ses.mntd(data)[,2], c(2,2,2,2,6,5)))
set.seed(123);test_that("D", expect_equal(.d(data), structure(c(-1.91147244241933, -1.59620673259184, -1.47692430746261, -0.184587530399159, 1.8475430319446, 1.54405249539692, 0, 0, 0, 0.006, 0.997, 0.919, 0.993, 0.991, 0.974, 0.64, 0, 0.003), .Dim = c(6L, 3L), .Dimnames = list(c("clump1", "clump2a", "clump2b", "clump4", "even", "random"), c("D", "P(D=1)", "P(D=0)")))))

#Dissimilarity
test_that("UniFrac", expect_equivalent(.unifrac(data), structure(c(0.625, 0.64, 0.8125, 0.789473684210526, 0.771428571428571, 0.653846153846154, 0.607142857142857, 0.763157894736842, 0.742857142857143, 0.571428571428571, 0.736842105263158, 0.714285714285714, 0.470588235294118, 0.675675675675676, 0.538461538461538), Labels = c("clump1", "clump2a", "clump2b", "clump4", "even", "random"), Size = 6L, class = "dist", Diag = FALSE, Upper = FALSE)))
#...PCD is not reproducible, so no test :-(
#...comdist has no good test either :-(

#Endemisim
test_that("PE", expect_equivalent(.pe(data), c(7.06666666666667, 5.73333333333333, 6.81666666666667, 7.48333333333333, 13.2833333333333, 12.6166666666667), tolerance=.0001))
test_that("BED", expect_equivalent(.bed(data), c(7.956061, 6.537879, 7.366667, 7.717424, 11.488258, 11.933712), tolerance=.0001))
}
