/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import java.util.ArrayList;
import java.util.List;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.Interpreter;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidAccess;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectFile;
import net.sf.eps2pgf.ps.objects.PSObjectFont;
import net.sf.eps2pgf.ps.objects.PSObjectIterator;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectNull;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import org.fontbox.afm.FontMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PSObject
implements Cloneable,
Iterable<PSObject> {
    private boolean literal = true;
    private Access access = Access.UNLIMITED;

    public PSObject abs() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject add(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject and(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject bind(Interpreter interpreter) throws PSErrorTypeCheck {
        return this;
    }

    public PSObject ceiling() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public void checkAccess(boolean bl, boolean bl2, boolean bl3) throws PSErrorInvalidAccess {
        if (this.access == Access.READONLY ? bl3 : (this.access == Access.EXECUTEONLY ? bl3 || bl2 : this.access == Access.NONE && (bl3 || bl2 || bl))) {
            throw new PSErrorInvalidAccess();
        }
    }

    public PSObject clone() {
        PSObject pSObject;
        try {
            pSObject = (PSObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            pSObject = new PSObjectNull();
            pSObject.copyCommonAttributes(this);
        }
        return pSObject;
    }

    public PSObject copy(PSObject pSObject) throws PSErrorRangeCheck, PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    protected void copyCommonAttributes(PSObject pSObject) {
        this.setAccess(pSObject.getAccess());
        this.literal = pSObject.literal;
    }

    public String cvrs(int n) throws PSErrorTypeCheck, PSErrorRangeCheck {
        throw new PSErrorTypeCheck();
    }

    public String cvs() {
        return "--nostringval--";
    }

    public PSObject cvx() {
        PSObject pSObject = this.dup();
        pSObject.literal = false;
        return pSObject;
    }

    public abstract PSObject dup();

    public boolean eq(PSObject pSObject) {
        return this == pSObject;
    }

    public abstract boolean equals(Object var1);

    public void executeonly() throws PSErrorTypeCheck {
        if (!(this instanceof PSObjectArray || this instanceof PSObjectFile || this instanceof PSObjectString)) {
            throw new PSErrorTypeCheck();
        }
        this.setAccess(Access.EXECUTEONLY);
    }

    public PSObject floor() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject get(PSObject pSObject) throws PSErrorTypeCheck, PSErrorRangeCheck, PSErrorUndefined {
        throw new PSErrorTypeCheck();
    }

    public PSObject getinterval(int n, int n2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public List<PSObject> getItemList() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public boolean gt(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public abstract int hashCode();

    public String isis() {
        return this.getClass().getName();
    }

    public static boolean isType(String string) {
        return false;
    }

    public PSObjectIterator iterator() {
        return new PSObjectIterator(this);
    }

    public int length() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject mul(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject neg() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public void noaccess() throws PSErrorTypeCheck {
        if (!(this instanceof PSObjectArray || this instanceof PSObjectFile || this instanceof PSObjectString || this instanceof PSObjectDict || this instanceof PSObjectFont)) {
            throw new PSErrorTypeCheck();
        }
        this.setAccess(Access.NONE);
    }

    public PSObject not() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject or(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public void put(PSObject pSObject, PSObject pSObject2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public void putinterval(int n, PSObject pSObject) throws PSErrorTypeCheck, PSErrorRangeCheck {
        throw new PSErrorTypeCheck();
    }

    public boolean rcheck() throws PSErrorTypeCheck {
        if (this instanceof PSObjectArray || this instanceof PSObjectFile || this instanceof PSObjectString || this instanceof PSObjectDict || this instanceof PSObjectFont) {
            Access access = this.getAccess();
            return access == Access.UNLIMITED || access == Access.READONLY;
        }
        throw new PSErrorTypeCheck();
    }

    public void readonly() throws PSErrorTypeCheck {
        if (!(this instanceof PSObjectArray || this instanceof PSObjectFile || this instanceof PSObjectString || this instanceof PSObjectDict || this instanceof PSObjectFont)) {
            throw new PSErrorTypeCheck();
        }
        this.setAccess(Access.READONLY);
    }

    public PSObject round() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObject sub(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObjectArray toArray() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public boolean toBool() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObjectDict toDict() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObjectFile toFile() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObjectFont toFont() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public FontMetric toFontMetric() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public int toInt() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public int cvi() throws PSError {
        throw new PSErrorTypeCheck();
    }

    public PSObject cvlit() throws PSErrorUnimplemented {
        PSObject pSObject = this.dup();
        pSObject.literal = true;
        return pSObject;
    }

    public double cvr() throws PSError {
        throw new PSErrorTypeCheck();
    }

    public PSObjectMatrix toMatrix() throws PSErrorRangeCheck, PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObjectName toName() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public int toNonNegInt() throws PSErrorRangeCheck, PSErrorTypeCheck {
        int n = this.toInt();
        if (n < 0) {
            throw new PSErrorRangeCheck();
        }
        return n;
    }

    public double toNonNegReal() throws PSErrorRangeCheck, PSErrorTypeCheck {
        double d = this.toReal();
        if (d < 0.0) {
            throw new PSErrorRangeCheck();
        }
        return d;
    }

    public PSObjectArray toProc() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public PSObjectString toPSString() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public double toReal() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public List<PSObject> token() throws PSError, ProgramError {
        ArrayList<PSObject> arrayList = new ArrayList<PSObject>(3);
        arrayList.add(0, null);
        arrayList.add(1, this);
        arrayList.add(2, new PSObjectBool(true));
        return arrayList;
    }

    public PSObject truncate() throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public String type() {
        return "generictype";
    }

    public boolean wcheck() throws PSErrorTypeCheck {
        if (this instanceof PSObjectArray || this instanceof PSObjectFile || this instanceof PSObjectString || this instanceof PSObjectDict || this instanceof PSObjectFont) {
            return this.getAccess() == Access.UNLIMITED;
        }
        throw new PSErrorTypeCheck();
    }

    public boolean xcheck() {
        return !this.literal;
    }

    public PSObject xor(PSObject pSObject) throws PSErrorTypeCheck {
        throw new PSErrorTypeCheck();
    }

    public void setLiteral(boolean bl) {
        this.literal = bl;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public Access getAccess() {
        return this.access;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Access {
        UNLIMITED,
        READONLY,
        EXECUTEONLY,
        NONE;

    }
}

