/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.InputStream;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectFile;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.filters.ASCII85Decode;
import net.sf.eps2pgf.ps.resources.filters.ASCIIHexDecode;
import net.sf.eps2pgf.ps.resources.filters.FlateDecode;
import net.sf.eps2pgf.ps.resources.filters.RunLengthDecode;
import net.sf.eps2pgf.ps.resources.filters.SubFileDecode;
import net.sf.eps2pgf.util.ArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterManager {
    public static final PSObjectName KEY_CLOSESOURCE = new PSObjectName("/CloseSource");
    public static final PSObjectName KEY_CLOSETARGET = new PSObjectName("/CloseTarget");
    public static final PSObjectName FILTER_ASCIIHEXDECODE = new PSObjectName("/ASCIIHexDecode");
    public static final PSObjectName FILTER_ASCII85DECODE = new PSObjectName("/ASCII85Decode");
    public static final PSObjectName FILTER_FLATEDECODE = new PSObjectName("/FlateDecode");
    public static final PSObjectName FILTER_RUNLENGTHDECODE = new PSObjectName("/RunLengthDecode");
    public static final PSObjectName FILTER_RUNLENGTHENCODE = new PSObjectName("/RunLengthEncode");
    public static final PSObjectName FILTER_SUBFILEDECODE = new PSObjectName("/SubFileDecode");

    private FilterManager() {
    }

    public static PSObjectDict getParameters(PSObjectName pSObjectName, ArrayStack<PSObject> arrayStack) throws PSError {
        PSObjectDict pSObjectDict;
        if (pSObjectName.eq(FILTER_SUBFILEDECODE)) {
            pSObjectDict = FilterManager.getParametersSubFileDecode(pSObjectName, arrayStack);
        } else if (pSObjectName.eq(FILTER_RUNLENGTHENCODE)) {
            pSObjectDict = FilterManager.getParametersRunLengthEncode(pSObjectName, arrayStack);
        } else {
            PSObject pSObject = arrayStack.pop();
            if (pSObject instanceof PSObjectDict) {
                pSObjectDict = (PSObjectDict)pSObject;
            } else {
                arrayStack.push(pSObject);
                pSObjectDict = new PSObjectDict();
            }
        }
        return pSObjectDict;
    }

    private static PSObjectDict getParametersSubFileDecode(PSObjectName pSObjectName, ArrayStack<PSObject> arrayStack) throws PSError {
        PSObjectDict pSObjectDict;
        PSObject pSObject = arrayStack.pop();
        if (pSObject instanceof PSObjectDict) {
            pSObjectDict = (PSObjectDict)pSObject;
        } else {
            PSObjectString pSObjectString = pSObject.toPSString();
            PSObjectInt pSObjectInt = new PSObjectInt(arrayStack.pop().toInt());
            pSObject = arrayStack.pop();
            if (pSObject instanceof PSObjectDict) {
                pSObjectDict = (PSObjectDict)pSObject;
            } else {
                arrayStack.push(pSObject);
                pSObjectDict = new PSObjectDict();
            }
            pSObjectDict.setKey((PSObject)SubFileDecode.KEY_EODSTRING, (PSObject)pSObjectString);
            pSObjectDict.setKey((PSObject)SubFileDecode.KEY_EODCOUNT, (PSObject)pSObjectInt);
        }
        return pSObjectDict;
    }

    private static PSObjectDict getParametersRunLengthEncode(PSObjectName pSObjectName, ArrayStack<PSObject> arrayStack) throws PSError {
        PSObjectDict pSObjectDict;
        int n = arrayStack.pop().toInt();
        PSObject pSObject = arrayStack.pop();
        if (pSObject instanceof PSObjectDict) {
            pSObjectDict = (PSObjectDict)pSObject;
        } else {
            arrayStack.push(pSObject);
            pSObjectDict = new PSObjectDict();
        }
        pSObjectDict.setKey("RecordSize", (PSObject)new PSObjectInt(n));
        return pSObjectDict;
    }

    public static PSObjectFile filter(PSObjectName pSObjectName, PSObjectDict pSObjectDict, PSObject pSObject) throws PSError {
        String string = pSObjectName.toString();
        if (string.endsWith("Decode")) {
            return FilterManager.filterDecode(pSObjectName, pSObjectDict, pSObject);
        }
        if (string.endsWith("Encode")) {
            return FilterManager.filterEncode(pSObjectName, pSObjectDict, pSObject);
        }
        throw new PSErrorTypeCheck();
    }

    private static PSObjectFile filterDecode(PSObjectName pSObjectName, PSObjectDict pSObjectDict, PSObject pSObject) throws PSError {
        InputStream inputStream;
        if (!(pSObject instanceof PSObjectFile)) {
            if (pSObject instanceof PSObjectString) {
                throw new PSErrorUnimplemented("Using string source for filter");
            }
            if (pSObject instanceof PSObjectArray) {
                PSObjectArray pSObjectArray = pSObject.toProc();
                throw new PSErrorUnimplemented("Using procedure source for filter");
            }
            throw new PSErrorTypeCheck();
        }
        InputStream inputStream2 = pSObject.toFile().getStream();
        if (pSObjectName.eq(FILTER_ASCIIHEXDECODE)) {
            inputStream = new ASCIIHexDecode(inputStream2, pSObjectDict);
        } else if (pSObjectName.eq(FILTER_ASCII85DECODE)) {
            inputStream = new ASCII85Decode(inputStream2, pSObjectDict);
        } else if (pSObjectName.eq(FILTER_FLATEDECODE)) {
            inputStream = new FlateDecode(inputStream2, pSObjectDict);
        } else if (pSObjectName.eq(FILTER_RUNLENGTHDECODE)) {
            inputStream = new RunLengthDecode(inputStream2, pSObjectDict);
        } else if (pSObjectName.eq(FILTER_SUBFILEDECODE)) {
            inputStream = new SubFileDecode(inputStream2, pSObjectDict);
        } else {
            throw new PSErrorUnimplemented("Decode filter or type " + pSObjectName);
        }
        return new PSObjectFile(inputStream);
    }

    private static PSObjectFile filterEncode(PSObjectName pSObjectName, PSObjectDict pSObjectDict, PSObject pSObject) throws PSError {
        throw new PSErrorUnimplemented("Encode filters");
    }

    public static boolean filterStatus(PSObject pSObject) throws PSError {
        String string = String.format("net.sf.eps2pgf.ps.resources.filters.%s", pSObject.toString());
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

