/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;

public class FlateEncode
extends DeflaterOutputStream {
    private boolean isClosed = false;
    private boolean closeTarget;

    public FlateEncode(OutputStream outputStream, PSObjectDict pSObjectDict) throws PSError {
        super(outputStream, new Deflater(9));
        PSObject pSObject = null;
        if (pSObjectDict != null) {
            pSObject = pSObjectDict.lookup(FilterManager.KEY_CLOSETARGET);
        }
        this.closeTarget = pSObject != null ? pSObject.toBool() : false;
    }

    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        super.flush();
    }

    public void write(int n) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        super.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        super.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        super.write(byArray, n, n2);
    }

    public void close() throws IOException {
        this.finish();
        if (this.closeTarget) {
            super.close();
        }
        this.isClosed = true;
    }
}

