/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASCII85Decode
extends InputStream {
    private InputStream in;
    private static final int EOF_CHAR = -1;
    private static final int IOEXCEPTION_CHAR = -2;
    private static final int EOD_CHAR = -3;
    private ArrayList<Integer> rawChars;
    private int rawPtr;
    private int lastMarkPtr = -1;
    private int[] decoded;
    private int decodedPtr;
    private int goodChars;
    private boolean closeSource;

    public ASCII85Decode(InputStream inputStream, PSObjectDict pSObjectDict) throws PSError {
        this.in = inputStream;
        this.decoded = new int[4];
        this.decodedPtr = 5;
        this.goodChars = 0;
        PSObject pSObject = pSObjectDict.lookup(FilterManager.KEY_CLOSESOURCE);
        this.closeSource = pSObject != null ? pSObject.toBool() : false;
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            int n = this.rawChars.size() - this.rawPtr;
            n = n * 4 / 5;
            return n;
        }
        throw new IOException();
    }

    @Override
    public void close() throws IOException {
        if (this.closeSource) {
            this.in.close();
        }
        this.in = null;
    }

    private static void decodeChars(long[] lArray, int[] nArray) throws IOException {
        long l = 0L;
        for (int i = 0; i < 5; ++i) {
            l = 85L * l + lArray[i] - 33L;
        }
        if (l >= 0x100000000L) {
            throw new IOException();
        }
        nArray[0] = (int)(l >> 24 & 0xFFL);
        nArray[1] = (int)(l >> 16 & 0xFFL);
        nArray[2] = (int)(l >> 8 & 0xFFL);
        nArray[3] = (int)(l & 0xFFL);
    }

    @Override
    public void mark(int n) {
        this.lastMarkPtr = this.rawPtr;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        if (this.rawChars == null) {
            this.rawChars = ASCII85Decode.readAllRawChars(this.in);
            this.rawPtr = 0;
        }
        if (this.decodedPtr >= this.goodChars) {
            long[] lArray = new long[5];
            int n = this.getNextFiveChars(lArray);
            if (n < 2) {
                return -1;
            }
            ASCII85Decode.decodeChars(lArray, this.decoded);
            this.decodedPtr = 0;
            this.goodChars = n - 1;
        }
        return this.decoded[this.decodedPtr++];
    }

    private static ArrayList<Integer> readAllRawChars(InputStream inputStream) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                int n2;
                if (n == 62 && (n2 = arrayList.get(arrayList.size() - 1).intValue()) == 126) {
                    arrayList.set(arrayList.size() - 1, -3);
                    break;
                }
                arrayList.add(n);
            }
        }
        catch (IOException iOException) {
            arrayList.add(-2);
        }
        arrayList.add(-1);
        return arrayList;
    }

    private int getNextFiveChars(long[] lArray) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n < 5) {
            int n3;
            if ((n3 = this.rawChars.get(this.rawPtr++).intValue()) >= 33 && n3 <= 117) {
                lArray[n++] = n3;
                ++n2;
                continue;
            }
            if (n == 0 && n3 == 122) {
                lArray[0] = 33L;
                lArray[1] = 33L;
                lArray[2] = 33L;
                lArray[3] = 33L;
                lArray[4] = 33L;
                n = 5;
                n2 = 5;
                continue;
            }
            if (n3 == -1 || n3 == -3) {
                --this.rawPtr;
                if (n > 0) {
                    lArray[n++] = 47L;
                    continue;
                }
                return -1;
            }
            if (n3 == 0 || n3 == 9 || n3 == 10 || n3 == 12 || n3 == 13 || n3 == 32) continue;
            throw new IOException();
        }
        return n2;
    }

    @Override
    public void reset() throws IOException {
        if (this.lastMarkPtr < 0) {
            throw new IOException();
        }
        this.rawPtr = this.lastMarkPtr;
        this.decodedPtr = 5;
    }
}

