% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_amd}
\alias{run_amd}
\title{run_amd}
\usage{
run_amd(
  input,
  modeltype = "pk_oral",
  cl_init = 0.01,
  vc_init = 1,
  mat_init = 0.1,
  search_space = NULL,
  lloq = NULL,
  order = NULL,
  categorical = NULL,
  continuous = NULL,
  allometric_variable = NULL,
  occasion = NULL
)
}
\arguments{
\item{input}{(Model) Read model object/Path to a dataset}

\item{modeltype}{(str) Type of model to build. Either 'pk_oral' or 'pk_iv'}

\item{cl_init}{(numeric) Initial estimate for the population clearance}

\item{vc_init}{(numeric) Initial estimate for the central compartment population volume}

\item{mat_init}{(numeric) Initial estimate for the mean absorption time (not for iv models)}

\item{search_space}{(str) MFL for search space for structural model}

\item{lloq}{(numeric) Lower limit of quantification. LOQ data will be removed.}

\item{order}{(vector) Runorder of components}

\item{categorical}{(vector) List of categorical covariates}

\item{continuous}{(vector) List of continuous covariates}

\item{allometric_variable}{(str or Symbol) Variable to use for allometry}

\item{occasion}{(str) Name of occasion column}
}
\value{
(Model) Reference to the same model object
}
\description{
Run Automatic Model Development (AMD) tool

Runs structural modelsearch, IIV building, and resmod
}
\examples{
\dontrun{
model <- load_example_model("pheno")
run_amd(model)
}
}
\seealso{
run_iiv

run_tool
}
