% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{calculate_individual_parameter_statistics}
\alias{calculate_individual_parameter_statistics}
\title{calculate_individual_parameter_statistics}
\usage{
calculate_individual_parameter_statistics(model, exprs, rng = NULL)
}
\arguments{
\item{model}{(Model) A previously estimated model}

\item{exprs}{(str, sympy expression or iterable of str or sympy expressions) Expressions or equations for parameters of interest. If equations are used
the names of the left hand sides will be used as the names of the parameters.}

\item{rng}{(Generator or integer) Random number generator or integer seed}
}
\value{
(data.frame) A DataFrame of statistics indexed on parameter and covariate value.
}
\description{
Calculate statistics for individual parameters

Calculate the mean (expected value of the distribution), variance
(variance of the distribution) and standard error for individual
parameters described by arbitrary expressions. Any dataset column or
variable used in the model can be used in the expression. The exception
being that variables that depends on the solution of the ODE system
cannot be used. If covariates are used in the expression the statistics
of the parameter is calculated at the median value of each covariate as well
as at the 5:th and 95:th percentiles. If no parameter uncertainty is available
for the model the standard error will not be calculated.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
rng <- create_rng(23)
calculate_individual_parameter_statistics(model, "K=CL/V", rng=rng)
}

}
