% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_phenocam.r
\name{download_phenocam}
\alias{download_phenocam}
\title{Function to download and post-process PhenoCam time series}
\usage{
download_phenocam(site = "harvard$", veg_type = NULL,
  frequency = "3", roi_id = NULL, outlier_detection = TRUE,
  smooth = TRUE, contract = FALSE, daymet = FALSE,
  trim_daymet = TRUE, trim = NULL, phenophase = FALSE,
  out_dir = tempdir(), internal = FALSE)
}
\arguments{
\item{site}{the site name, as mentioned on the PhenoCam web page expressed
as a regular expression ("harvard$" == exact match)}

\item{veg_type}{vegetation type (DB, EN, ... default = ALL)}

\item{frequency}{frequency of the time series product (1, 3, "roistats")}

\item{roi_id}{the id of the ROI to download (default = ALL)}

\item{outlier_detection}{TRUE or FALSE, detect outliers}

\item{smooth}{smooth data (logical, default is \code{TRUE})}

\item{contract}{contract 3-day data (logical, default is \code{TRUE})}

\item{daymet}{TRUE or FALSE, merges the daymet data}

\item{trim_daymet}{TRUE or FALSE, trims data to match PhenoCam data}

\item{trim}{year (numeric) to which to constrain the output (default = \code{NULL})}

\item{phenophase}{logical, calculate transition dates (default = \code{FALSE})}

\item{out_dir}{output directory where to store downloaded data 
(default = tempdir())}

\item{internal}{allow for the data element to be returned to the workspace}
}
\value{
Downloaded files in out_dir of requested time series products, as well
as derived phenophase estimates based upon these time series.
}
\description{
This is a wrapper around most of all the other functions.
It downloads a time series and extract relevant phenological transition
dates or phenophases.
}
\examples{

\donttest{
# download the first ROI time series for the Harvard PhenoCam site
# at an aggregation frequency of 3-days.
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3")
 
# read phenocam data into phenocamr data structure                  
df <- read_phenocam(file.path(tempdir(),"harvard_DB_1000_3day.csv"))
                  
}
}
\keyword{Daymet,}
\keyword{PhenoCam,}
\keyword{climate}
\keyword{data,}
\keyword{modelling,}
\keyword{post-processing}
