% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_ts.r
\name{smooth_ts}
\alias{smooth_ts}
\title{Smooth a PhenoCam time series}
\usage{
smooth_ts(
  data,
  metrics = c("gcc_mean", "gcc_50", "gcc_75", "gcc_90", "rcc_mean", "rcc_50", "rcc_75",
    "rcc_90"),
  force = TRUE,
  internal = TRUE,
  out_dir = tempdir()
)
}
\arguments{
\item{data}{a PhenoCam data file or data structure}

\item{metrics}{which metrics to process, normally all default ones}

\item{force}{\code{TRUE} / \code{FALSE}, force reprocessing?}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)}

\item{out_dir}{output directory where to store data}
}
\value{
An PhenoCam data structure or file with optimally smoothed time series
objects added to the original file. Smoothing is required for `phenophase()`
and `transition_dates()` functions.
}
\description{
Smooths time series iteratively using a Akaike information criterion (AIC) 
to find an optimal smoothing parameter and curve.
}
\examples{

\dontrun{
# with defaults, outputting a data frame
# with smoothed values, overwriting the original

# download demo data (do not smooth)
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3",
                  smooth = FALSE)

# smooth the downloaded file (and overwrite the original)
smooth_ts(file.path(tempdir(),"harvard_DB_1000_3day.csv"))

# the function also works on a PhenoCam data frame
df <- read_phenocam(file.path(tempdir(),"harvard_DB_1000_3day.csv"))
df <- smooth_ts(df)
}
}
