% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pheno.R
\name{get_pheno}
\alias{get_pheno}
\alias{get_pheno.fFITs}
\title{get_pheno}
\usage{
get_pheno(
  fits,
  method,
  TRS = c(0.2, 0.5, 0.6),
  analytical = TRUE,
  smoothed.spline = FALSE,
  IsPlot = FALSE,
  show_title = TRUE,
  ...
)

get_pheno.fFITs(
  fFITs,
  method,
  TRS = c(0.2, 0.5),
  analytical = TRUE,
  smoothed.spline = FALSE,
  IsPlot = FALSE,
  title_left = "",
  showName_pheno = TRUE
)
}
\arguments{
\item{fits}{A list of \code{\link[=fFITs]{fFITs()}} object, for a single curve fitting
method.}

\item{method}{Which fine curve fitting method to be extracted?}

\item{TRS}{Threshold for \code{PhenoTrs}.}

\item{analytical}{If true, \code{numDeriv} package \code{grad} and \code{hess}
will be used; if false, \code{D1} and \code{D2} will be used.}

\item{smoothed.spline}{Whether apply \code{smooth.spline} first?}

\item{IsPlot}{Boolean. Whether to plot figure?}

\item{show_title}{Whether to show the name of fine curve fitting method
in top title?}

\item{...}{ignored.}

\item{fFITs}{\code{fFITs} object returned by \code{\link[=curvefit]{curvefit()}}.}

\item{title_left}{String of growing season flag.}

\item{showName_pheno}{Whether to show phenological methods names in the top panel?}
}
\value{
List of every year phenology metrics
}
\description{
Get yearly vegetation phenological metrics of a curve fitting method
}
\note{
Please note that only a single fine curve fitting method allowed here!
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c( mn  = 0.1, mx  = 0.7, sos = 50, rsp = 0.1, eos = 250, rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)
methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fFITs <- curvefit(y, t, tout, methods)
# multiple years
fits  <- list(`2001` = fFITs, `2002` = fFITs)

l_param   <- get_param(fits)
d_GOF     <- get_GOF(fits)
d_fitting <- get_fitting(fits)
l_pheno   <- get_pheno(fits, "AG", IsPlot=TRUE)
}
