% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_HeadTail.R
\name{add_HeadTail}
\alias{add_HeadTail}
\title{Add one year data in the head and tail}
\usage{
add_HeadTail(d, south = FALSE, nptperyear, trs = 0.45)
}
\arguments{
\item{d}{A data.table, should have \code{t} (compositing date) or \code{date}
(image date) column which are (\code{Date} variable).}

\item{south}{Boolean. In south hemisphere, growing year is 1 July to the
following year 31 June; In north hemisphere, growing year is 1 Jan to 31 Dec.}

\item{nptperyear}{Integer, number of images per year.}

\item{trs}{If nmissing < trs*nptperyear (little missing), this year is
include to extract phenology; if \code{FALSE}, this year is excluded.}
}
\value{
data.table
}
\description{
Add the data of the year of \code{year_start - 1} to the head, add the data of the
year of \code{year_end - 1} to the tail.
}
\note{
\code{date} is image date; \code{t} is compositing date.
}
\examples{
library(phenofit)
data("CA_NS6"); d = CA_NS6

nptperyear = 23
dnew     <- add_HeadTail(d, nptperyear = nptperyear) # add one year in head and tail
}
\keyword{internal}
