% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cologne.R
\name{cologne}
\alias{cologne}
\title{Cologne Phonetic Name Coding}
\usage{
cologne(word, maxCodeLen = NULL, clean = TRUE)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}

\item{clean}{if \code{TRUE}, return \code{NA} for unknown alphabetical characters}
}
\value{
the Cologne encoded character vector
}
\description{
The Cologne phonetic name coding procedure.
}
\details{
The variable \code{word} is the name to be encoded.  The variable
\code{maxCodeLen} is the limit on how long the returned name code
should be.  The default is 4.

The \code{cologne} algorithm is only defined for inputs over the
standard English alphabet, \emph{i.e.}, "A-Z," "Ä," "Ö," "Ü," and
"ß." Non-alphabetical characters are removed from the string in a
locale-dependent fashion.  This strips spaces, hyphens, and numbers.
Other letters, such as "ç," may be permissible in the current locale
but are unknown to \code{cologne}.  For inputs outside of its known
range, the output is undefined and \code{NA} is returned and a
\code{warning} this thrown.  If \code{clean} is \code{FALSE},
\code{cologne} attempts to process the strings.  The default is
\code{TRUE}.
}
\examples{
cologne("William")
cologne(c("Peter", "Peady"))
cologne("Stevenson", maxCodeLen = 8)

}
\references{
Hans Joachim Postel. "Die Koelner Phonetik. Ein Verfahren zur
Identifizierung von Personennamen auf der Grundlage der
Gestaltanalyse."  \emph{IBM-Nachrichten} 19. Jahrgang, 1969,
p. 925-931.
}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{lein}}, \code{\link{metaphone}},
  \code{\link{mra_encode}}, \code{\link{nysiis}},
  \code{\link{onca}}, \code{\link{phonex}},
  \code{\link{phonics}}, \code{\link{rogerroot}},
  \code{\link{soundex}}, \code{\link{statcan}}
}
\concept{phonics}
