% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.mean.r
\name{s_mean}
\alias{s_mean}
\alias{s_mean.default}
\alias{s_mean.source_mspct}
\alias{s_mean.response_mspct}
\alias{s_mean.filter_mspct}
\alias{s_mean.reflector_mspct}
\alias{s_mean.calibration_mspct}
\alias{s_mean.cps_mspct}
\alias{s_mean.raw_mspct}
\title{Mean from collection of spectra}
\usage{
s_mean(x, trim, na.rm, ...)

\method{s_mean}{default}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{source_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{response_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{filter_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{reflector_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{calibration_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{cps_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{raw_mspct}(x, trim = 0, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object Currently this package defines methods for collections of
spectral objects.}

\item{trim}{numeric The fraction (0 to 0.5) of observations to be trimmed from
each end of x before the mean is computed. Values of trim outside that
range are taken as the nearest endpoint.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of same class as the
  members of the collection, such as "filter_spct", containing the mean
  spectrum.
}
\description{
A method to compute the mean of values across members of a collections of
spectra. Computes the mean at each wavelength across all the spectra in the
collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_mean(default)}: 

\item \code{s_mean(source_mspct)}: 

\item \code{s_mean(response_mspct)}: 

\item \code{s_mean(filter_mspct)}: 

\item \code{s_mean(reflector_mspct)}: 

\item \code{s_mean(calibration_mspct)}: 

\item \code{s_mean(cps_mspct)}: 

\item \code{s_mean(raw_mspct)}: 

}}
\note{
Trimming of extreme values and omission of NAs is done separately at
  each wavelength. Interpolation is not applied, so all spectra in \code{x}
  must share the same set of wavelengths.

  Objects of classes raw_spct and cps_spct can contain data from multiple
  scans. This functions are implemented for these classes only for the case
  when all member spectra contain data for a single scan, or spliced into a
  single column in the case of cps_spct members.
}
\seealso{
See \code{\link[base]{mean}} for the \code{mean()} method used for
  the computations.
}
