% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{log}
\alias{log}
\alias{log.generic_spct}
\alias{log2.generic_spct}
\alias{log10.generic_spct}
\alias{exp.generic_spct}
\title{Logarithms and Exponentials}
\usage{
\method{log}{generic_spct}(x, base = exp(1))

\method{log2}{generic_spct}(x)

\method{log10}{generic_spct}(x)

\method{exp}{generic_spct}(x)
}
\arguments{
\item{x}{an object of class "generic_spct"}

\item{base}{a positive number: the base with respect to which logarithms are
computed. Defaults to e=exp(1).}
}
\value{
An object of the same class as \code{x}.
}
\description{
Logarithms and Exponentials for Spectra. The functions are applied to the
spectral data, not the wavelengths. The quantity in the spectrum to which the
function is applied depends on the class of \code{x} and the current value of
output options
}
\note{
In most cases a logarithm of an spectral quantity will yield off-range
  values. For this reason unless \code{x} is an object of base class
  \code{generic_spct}, checks will not be passed, resulting in warnings or
  errors.
}
\seealso{
Other math operators and functions: 
\code{\link{MathFun}},
\code{\link{^.generic_spct}()},
\code{\link{convolve_each}()},
\code{\link{div-.generic_spct}},
\code{\link{minus-.generic_spct}},
\code{\link{mod-.generic_spct}},
\code{\link{plus-.generic_spct}},
\code{\link{round}()},
\code{\link{sign}()},
\code{\link{slash-.generic_spct}},
\code{\link{times-.generic_spct}}
}
\concept{math operators and functions}
