% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.irrad.r
\name{q_irrad}
\alias{q_irrad}
\alias{q_irrad.default}
\alias{q_irrad.source_spct}
\alias{q_irrad.source_mspct}
\title{Photon irradiance}
\usage{
q_irrad(
  spct,
  w.band,
  quantity,
  time.unit,
  scale.factor,
  wb.trim,
  use.cached.mult,
  use.hinges,
  allow.scaled,
  ...
)

\method{q_irrad}{default}(
  spct,
  w.band,
  quantity,
  time.unit,
  scale.factor,
  wb.trim,
  use.cached.mult,
  use.hinges,
  allow.scaled,
  ...
)

\method{q_irrad}{source_spct}(
  spct,
  w.band = NULL,
  quantity = "total",
  time.unit = NULL,
  scale.factor = 1,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default = FALSE),
  use.hinges = NULL,
  allow.scaled = !quantity \%in\% c("average", "mean", "total"),
  naming = "default",
  return.tb = FALSE,
  ...
)

\method{q_irrad}{source_mspct}(
  spct,
  w.band = NULL,
  quantity = "total",
  time.unit = NULL,
  scale.factor = 1,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default = FALSE),
  use.hinges = NULL,
  allow.scaled = !quantity \%in\% c("average", "mean", "total"),
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{an R object.}

\item{w.band}{a list of \code{waveband} objects or a \code{waveband} object.}

\item{quantity}{character string One of "total", "average" or "mean",
"contribution", "contribution.pc", "relative" or "relative.pc".}

\item{time.unit}{character or lubridate::duration object.}

\item{scale.factor}{numeric vector of length 1, or length equal to that of
\code{w.band}. Numeric multiplier applied to returned values.}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded.}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error.}

\item{...}{other arguments (possibly ignored).}

\item{naming}{character one of "long", "default", "short" or "none". Used to
select the type of names to assign to returned value.}

\item{return.tb}{logical Flag forcing a tibble to be always returned, even
for a single spectrum as argumnet to \code{spct}. The default is
\code{FALSE} for backwards compatibility.}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector in the case of a \code{_spct} object
  containing a single spectrum and \code{return.tb = FALSE}. The vector has
  one member one value for each \code{waveband} passed to parameter
  \code{w.band}. In all other cases a \code{tibble}, containing one column
  for each \code{waveband} object, an index column with the names of the
  spectra, and optionally additional columns with metadata values retrieved
  from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used. The time.unit
  attribute is copied from the spectrum object to the output. Units are as
  follows: If time.unit is second, [W m-2 nm-1] -> [mol s-1 m-2] If time.unit
  is day, [J d-1 m-2 nm-1] -> [mol d-1 m-2]
}
\description{
Photon irradiance (i.e. quantum irradiance) for one or more wavebands of a
light source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{q_irrad(default)}: Default for generic function

\item \code{q_irrad(source_spct)}: Calculates photon irradiance from a \code{source_spct}
object.

\item \code{q_irrad(source_mspct)}: Calculates photon (quantum) irradiance from a
\code{source_mspct} object.

}}
\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in most cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
q_irrad(sun.spct, waveband(c(400,700)))
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3))
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "total")
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "average")
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "relative")
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "relative.pc")
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "contribution")
q_irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "contribution.pc")

}
\seealso{
Other irradiance functions: 
\code{\link{e_fluence}()},
\code{\link{e_irrad}()},
\code{\link{fluence}()},
\code{\link{irrad}()},
\code{\link{q_fluence}()}
}
\concept{irradiance functions}
