% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setGenericSpct}
\alias{setGenericSpct}
\alias{setCalibrationSpct}
\alias{setRawSpct}
\alias{setCpsSpct}
\alias{setFilterSpct}
\alias{setReflectorSpct}
\alias{setObjectSpct}
\alias{setResponseSpct}
\alias{setSourceSpct}
\alias{setChromaSpct}
\title{Convert an R object into a spectrum object.}
\usage{
setGenericSpct(x, multiple.wl = 1L)

setCalibrationSpct(x, strict.range = getOption("photobiology.strict.range",
  default = FALSE), multiple.wl = 1L)

setRawSpct(x, strict.range = getOption("photobiology.strict.range", default =
  FALSE), multiple.wl = 1L)

setCpsSpct(x, strict.range = getOption("photobiology.strict.range", default =
  FALSE), multiple.wl = 1L)

setFilterSpct(x, Tfr.type = c("total", "internal"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L)

setReflectorSpct(x, Rfr.type = c("total", "specular"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L)

setObjectSpct(x, Tfr.type = c("total", "internal"), Rfr.type = c("total",
  "specular"), strict.range = getOption("photobiology.strict.range", default =
  FALSE), multiple.wl = 1L)

setResponseSpct(x, time.unit = "second", multiple.wl = 1L)

setSourceSpct(x, time.unit = "second", bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L)

setChromaSpct(x, multiple.wl = 1L)
}
\arguments{
\item{x}{data.frame, list or generic_spct and derived classes}

\item{multiple.wl}{numeric Maximum number of repeated w.length entries with same value.}

\item{strict.range}{logical Flag indicating whether off-range values result in an
error instead of a warning.}

\item{Tfr.type}{character A string, either "total" or "internal".}

\item{Rfr.type}{character A string, either "total" or "specular".}

\item{time.unit}{character A string "second", "day" or "exposure".}

\item{bswf.used}{character A string, either "none" or the name of a BSWF.}
}
\value{
x
}
\description{
Sets the class attibute of a data.frame or an object of a derived
class to "generic_spct".
}
\section{Functions}{
\itemize{
\item \code{setCalibrationSpct}: Set class of a an object to "calibration_spct".

\item \code{setRawSpct}: Set class of a an object to "raw_spct".

\item \code{setCpsSpct}: Set class of a an object to "cps_spct".

\item \code{setFilterSpct}: Set class of an object to "filter_spct".

\item \code{setReflectorSpct}: Set class of a an object to "reflector_spct".

\item \code{setObjectSpct}: Set class of an object to "object_spct".

\item \code{setResponseSpct}: Set class of an object to "response_spct".

\item \code{setSourceSpct}: Set class of an object to "source_spct".

\item \code{setChromaSpct}: Set class of an object to "chroma_spct".
}}

\note{
This method alters x itself by reference and in addition
  returns x invisibly.
}
\examples{
my.df <- data.frame(w.length = 300:309, s.e.irrad = rep(100, 10))
is.source_spct(my.df)
setSourceSpct(my.df)
is.source_spct(my.df)

}
\seealso{
Other set and unset spectral class functions: \code{\link{rmDerivedSpct}}
}
