% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{as.generic_mspct}
\alias{as.generic_mspct}
\alias{as.generic_mspct.default}
\alias{as.generic_mspct.data.frame}
\alias{as.generic_mspct.generic_spct}
\alias{as.generic_mspct.list}
\alias{as.generic_mspct.matrix}
\alias{mat2mspct}
\title{Coerce to a collection-of-spectra}
\usage{
as.generic_mspct(x, ...)

\method{as.generic_mspct}{default}(x, ...)

\method{as.generic_mspct}{data.frame}(x, force.spct.class = FALSE, ...)

\method{as.generic_mspct}{generic_spct}(x, force.spct.class = FALSE, ...)

\method{as.generic_mspct}{list}(x, force.spct.class = FALSE, ..., ncol = 1,
  byrow = FALSE)

\method{as.generic_mspct}{matrix}(x, w.length, member.class, spct.data.var,
  multiplier = 1, byrow = NULL, spct.names = "spct_", ...)

mat2mspct(x, w.length, member.class, spct.data.var, multiplier = 1,
  byrow = NULL, spct.names = "spct_", ...)
}
\arguments{
\item{x}{a list of spectral objects or a list of objects such as data frames
that can be converted into spectral objects.}

\item{...}{passed to individual spectrum object constructor}

\item{force.spct.class}{logical indicating whether to change the class
of members to \code{generic_spct} or retain the existing class.}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}

\item{w.length}{numeric A vector of wavelengthvalues sorted in strictly ascending
order (nm).}

\item{member.class}{character The name of the class of the individual spectra
to be constructed.}

\item{spct.data.var}{character The name of the variable that will contain the
spectral data. This indicates what physical quantity is stored in the matrix
and the units of expression used.}

\item{multiplier}{numeric A multiplier to be applied to the values in \code{x} to do
unit or scale conversion.}

\item{spct.names}{character Vector of names to be assigned to collection members,
either of length 1, or with length equal to the number of spectra.}
}
\value{
A copy of \code{x} converted into a \code{generic_mspct} object.
}
\description{
Return a copy of an R object with its class set to a given type
  of spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{data.frame}: 

\item \code{generic_spct}: 

\item \code{list}: 

\item \code{matrix}: 
}}

\note{
Members of \code{generic_mspct} objects can be heterogeneous: they can
  belong to any class derived from \code{generic_spct} and class is not
  enforced. When \code{x} is a list of data frames
  \code{force.spct.class = TRUE} needs to be supplied. When \code{x} is a
  square matrix an explicit argument is needed for \code{byrow} to indicate
  how data in \code{x} should be read. In every case the length of the
  \code{w.length} vector must match one of the dimensions of \code{x}.
}
\seealso{
Other Coercion methods for collections of spectra: \code{\link{as.calibration_mspct}},
  \code{\link{as.chroma_mspct}},
  \code{\link{as.cps_mspct}},
  \code{\link{as.filter_mspct}},
  \code{\link{as.object_mspct}},
  \code{\link{as.raw_mspct}},
  \code{\link{as.reflector_mspct}},
  \code{\link{as.response_mspct}},
  \code{\link{as.source_mspct}}, \code{\link{split2mspct}},
  \code{\link{subset2mspct}}
}
