% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{get_peaks}
\alias{get_peaks}
\alias{get_valleys}
\title{Get peaks and valleys in a spectrum}
\usage{
get_peaks(
  x,
  y,
  ignore_threshold = 0,
  span = 5,
  strict = TRUE,
  x_unit = "",
  x_digits = 3,
  na.rm = FALSE
)

get_valleys(
  x,
  y,
  ignore_threshold = 0,
  span = 5,
  strict = TRUE,
  x_unit = "",
  x_digits = 3,
  na.rm = FALSE
)
}
\arguments{
\item{x}{numeric}

\item{y}{numeric}

\item{ignore_threshold}{numeric Value between 0.0 and 1.0 indicating the
relative size compared to tallest peak or deepest valley of the peaks
to return.}

\item{span}{numeric A peak is defined as an element in a sequence which is
greater than all other elements within a window of width \code{span}
centered at that element. For example, a value of 3 means that a peak is
bigger than both of its neighbors.}

\item{strict}{logical Flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{x_unit}{character Vector of texts to be pasted at end of labels built
from x value at peaks.}

\item{x_digits}{numeric Number of significant digits in wavelength label.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}
}
\value{
A data frame with variables w.length and s.irrad with their values at
  the peaks or valleys plus a character variable of labels.
}
\description{
These functions find peaks (local maxima) or valleys (local minima) in a
spectrum, using a user selectable size threshold relative to the tallest peak
(global maximum). This a wrapper built on top of function peaks from package
splus2R.
}
\examples{
with(sun.spct, get_peaks(w.length, s.e.irrad))
with(sun.spct, get_valleys(w.length, s.e.irrad))

}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{peaks}()},
\code{\link{valleys}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
