% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.mean.se.r
\name{s_mean_se}
\alias{s_mean_se}
\alias{s_mean_se.default}
\alias{s_mean_se.filter_mspct}
\alias{s_mean_se.source_mspct}
\alias{s_mean_se.response_mspct}
\alias{s_mean_se.reflector_mspct}
\alias{s_mean_se.calibration_mspct}
\title{Mean and standard error from collection of spectra}
\usage{
s_mean_se(x, na.rm, mult, ...)

\method{s_mean_se}{default}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{filter_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{source_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{response_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{reflector_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{calibration_mspct}(x, na.rm = FALSE, mult = 1, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections of
spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{mult}{numeric number of multiples of standard error}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of same class as the
  members of the collection, such as "filter_spct", containing the mean
  spectrum.
}
\description{
A method to compute the mean of values across members of a collections of
spectra. Computes the mean at each wavelength across all the spectra in the
collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{filter_mspct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{reflector_mspct}: 

\item \code{calibration_mspct}: 
}}

\note{
Trimming of extreme values and omission of NAs is done separately at
each wavelength. Interpolation is not applied, so all spectra in \code{x}
must share the same set of wavelengths.
}
\seealso{
See \code{\link[base]{mean}} for the \code{mean()} method used for
  the computations.
}
