#' Indexing of theatrical "gels"
#'
#' Vectors of names of member objects with spectral transmittance for different
#' filters used on light sources in theatres, photo and video studios as
#' spectral modifiers. Frequently called "theatrical gels".
#'
#' @references
#' \url{https://leefilters.com/lighting/colour-effect-lighting-filters/},
#' \url{https://emea.rosco.com/en/products/family/filters-and-diffusions}
#'
#' @note Instruments used: Shimadzu UV-2501 PC (Shimadzu Suzhou Instruments
#'   Manufacturing Co. Ltd, China) equipped with an integrating sphere for Rosco
#'   filters except no. 299 which was measured with an Agilent 8453 array
#'   spectrophotometer. Spectra for Lee gels have been digitized from
#'   the spectral plots in the Lee filters catalogue.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @seealso \code{\link{filters.mspct}}
#'
#' @examples
#' theatrical_gels
#'
"theatrical_gels"

#' @rdname theatrical_gels
#'
"lee_filters"

#' @rdname theatrical_gels
#'
"lee_gels"

#' @rdname theatrical_gels
#'
"rosco_filters"

#' @rdname theatrical_gels
#'
"rosco_gels"
