\docType{data}
\name{ex18}
\alias{ex18}
\title{Example 18--Inverse Modeling of the Madison Aquifer}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
In this example, inverse modeling, including isotope
mole-balance modeling, is applied to the evolution of water
in the Madison aquifer in Montana. Plummer and others
(1990) used mole-balance modeling to quantify the extent of
dedolomitization at locations throughout the aquifer. In
the dedolomitization process, anhydrite dissolution causes
the precipitation of calcite and dissolution of dolomite.
Additional reactions identified by mole-balance modeling
include sulfate reduction, cation exchange, and halite and
sylvite dissolution (Plummer and others, 1990). Del 13C and
del 34S data were used to corroborate the mole-balance
models and carbon-14 was used to estimate groundwater ages
(Plummer and others, 1990). Initial and final water samples
were selected from a flow path that extends from
north-central Wyoming northeast across Montana (Plummer and
others, 1990, flow path 3). This pair of water samples was
selected specifically because it was one of the few pairs
that showed a relatively large discrepancy between previous
mole-balance approaches and the mole-balance approach of
PHREEQC, which includes uncertainties; results for most
sample pairs were not significantly different between the
two approaches. In addition, this pair of samples was
selected because it was modeled in detail in Plummer and
others (1990) to determine the sensitivity of mole-balance
results to various model assumptions and was used as an
example in the NETPATH manual (Plummer and others, 1994,
example 6). Results of PHREEQC calculations are compared to
NETPATH calculations. This example is also discussed in
Parkhurst (1997). The example can be run using the
\code{\link{phrRunString}} routine.
}
\examples{
phrLoadDatabaseString(phreeqc.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex18)
phrGetOutputStrings()
}
\references{
\url{http://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: \code{\link{ex10}}; \code{\link{ex11}};
\code{\link{ex12}}; \code{\link{ex13a}},
\code{\link{ex13a}}, \code{\link{ex13b}},
\code{\link{ex13c}}; \code{\link{ex14}};
\code{\link{ex15}}; \code{\link{ex16}}; \code{\link{ex17}};
\code{\link{ex19}}; \code{\link{ex1}}; \code{\link{ex20a}},
\code{\link{ex20a}}, \code{\link{ex20b}};
\code{\link{ex21}}; \code{\link{ex22}}; \code{\link{ex2}};
\code{\link{ex3}}; \code{\link{ex4}}; \code{\link{ex5}};
\code{\link{ex6}}; \code{\link{ex7}}; \code{\link{ex8}};
\code{\link{ex9}}
}
\keyword{dataset}

