% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrans.R
\name{plotTrans}
\alias{plotTrans}
\title{Plotting a phybreak object transmission tree.}
\usage{
plotTrans(x, plot.which = c("sample", "edmonds", "mpc", "mtcc"),
  samplenr = 0, mar = 0.1 + c(4, 0, 0, 0), label.cex = NULL,
  label.space = 0.15, label.adj = 0, arrow.lwd = 1, arrow.length = NULL,
  arrow.col = NULL, sample.pch = 4, sample.lwd = NULL,
  sample.cex = label.cex, polygon.col = "gray", polygon.border = NA,
  line.lty = 3, xlab = "Time", axis.cex = 1, title.cex = 1, ...)
}
\arguments{
\item{x}{An object of class \code{phybreak}.}

\item{plot.which}{Either \code{"sample"} to plot the current state or a selected posterior sample, 
\code{"mpc"} or \code{"mtcc"} to plot a consensus transmission tree (see \code{\link{transtree}}) or \code{"mcc"}
to plot the maximum clade credibility tree (see \code{\link{phylotree}}).}

\item{samplenr}{If \code{plot.which = "sample"}, this indicates which posterior tree should be plotted: 
\code{samplenr = 0} to plot the current state.}

\item{mar}{Plot margins.}

\item{label.cex}{Size of host names, as in \code{par("cex")}. Defaults to a value between 0.5 and 1
depending on outbreak size.}

\item{label.space}{Scales the space at the right-hand side to place the host names.}

\item{label.adj}{Left-right adjustment of host names.}

\item{arrow.lwd}{Arrow width.}

\item{arrow.length}{Arrow point length, as default automatically scaled with outbreak size.}

\item{arrow.col}{Arrow colour. Defaults to \code{"black"} if \code{plot.which = sample}, and otherwise to five
colours \code{c("blue", "green", "orange", "red", "purple")} indicating posterior support of infectors
in bins of 0.2 width, from low to high support. Any vector of colours will be divided into equal-sized bins.}

\item{sample.pch}{Character \code{par("pch")} used for sampling events.}

\item{sample.lwd}{Line width of sampling event character.}

\item{sample.cex}{Size of sampling event character.}

\item{polygon.col}{Color of polygons indicating generation interval distributions.}

\item{polygon.border}{Border of polygon.}

\item{line.lty}{Line type of horizontal host lines.}

\item{xlab}{X-axis title.}

\item{axis.cex}{Size of tick labels.}

\item{title.cex}{Size of X-axis title.}

\item{...}{Further graphical parameters (see details).}
}
\description{
Plots a \code{phybreak}-object as transmission tree. The default 
  is to plot the current state, but any posterior sample can be chosen, as well as various 
  consensus trees; in that case, coloured arrows indicate posterior support.
}
\section{Details}{
 
  Graphical parameters can be added by using names in the format \code{prefix.parameter} for the
  different parts of the plot. The \code{parameter} will then be passed on to the appropriate 
  graphics function, e.g. \code{arrow.lty} to change the line type of the arrows. The following 
  prefixes can be used: \code{label} for the host labels, \code{arrow} for the arrows, \code{sample}
  for the sampling time indicators, \code{polygon} for the generation interval distributions, 
  \code{line} for the horizontal host lines, \code{axis} for the X-axis, and \code{title} for the
  X-axis title.
}

\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

plot(MCMCstate, plot.which = "mpc")
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
