% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configShow.R
\name{configShow}
\alias{configShow}
\title{Plot a tree highlighting configurations}
\usage{
configShow(tree, configSize, mainCol = "black", configCol = "red", ...)
}
\arguments{
\item{tree}{a tree of class \code{phylo4}}

\item{configSize}{an integer giving the configuration size of interest}

\item{mainCol}{colour for branches which are not in configurations of the chosen size (default is black)}

\item{configCol}{colour for branches which are in such configurations (default is red)}

\item{...}{further arguments to be passed to plot.phylo}
}
\value{
A plot of the tree, highlighting the configurations of the given size.
}
\description{
Plot a tree, highlighting configurations of a given size.
}
\examples{
## Highlight pitchforks in a random tree with 20 tips:
configShow(rtree(20),3, edge.width=2)

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}

Michael Boyd \email{mboyd855@gmail.com}
}

