% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reorder-methods.R
\docType{methods}
\name{reorder-methods}
\alias{reorder}
\alias{reorder,phylo4-method}
\alias{reorder-methods}
\title{reordering trees within phylobase objects}
\usage{
reorder(x, ...)

\S4method{reorder}{phylo4}(x, order = c("preorder", "postorder"))
}
\arguments{
\item{x}{a \code{phylo4} or \code{phylo4d} object}

\item{order}{The desired traversal order; currently only
\dQuote{preorder} and \dQuote{postorder} are allowed for
\code{phylo4} and \code{phylo4d} objects.}

\item{\dots}{additional optional elements (not in use)}
}
\value{
A \code{phylo4} or \code{phylo4d} object with the edge,
label, length and data slots ordered as \code{order}, which is
itself recorded in the order slot.
}
\description{
Methods for reordering trees into various traversal orders
}
\details{
The \code{reorder} method takes a \code{phylo4} or \code{phylo4d}
tree and orders the edge matrix (i.e. \code{edges(x)}) in the
requested traversal order. Currently only two orderings are
permitted, and both require rooted trees. In \code{postorder}, a
node's descendants come before that node, thus the root, which is
ancestral to all nodes, comes last.  In \code{preorder}, a node is
visited before its descendants, thus the root comes first.
}
\note{
The \code{preorder} parameter corresponds to
\code{cladewise} in the \code{ape} package, and \code{postorder}
corresponds (almost) to \code{pruningwise}.
}
\examples{
phy <- phylo4(ape::rtree(5))
edges(reorder(phy, "preorder"))
edges(reorder(phy, "postorder"))
}
\author{
Peter Cowan, Jim Regetz
}
\seealso{
\code{\link[ape]{reorder.phylo}} in the \code{ape} package.
\code{\link{ancestors}} \code{\link{ancestor}} \code{\link{siblings}}
\code{\link{children}} \code{\link{descendants}}
}
\keyword{methods}

